/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.core.operation.local.RunExternalCompareOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.compare.ComparePanel;
import org.eclipse.team.svn.ui.compare.ConflictingFileEditorInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.preferences.SVNTeamDiffViewerPage;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class ShowConflictEditorOperation
extends AbstractWorkingCopyOperation {
    protected boolean showInDialog;

    public ShowConflictEditorOperation(IResource[] resources, boolean showInDialog) {
        super("Operation_ShowConflictEditor", SVNUIMessages.class, resources);
        this.showInDialog = showInDialog;
    }

    public ShowConflictEditorOperation(IResourceProvider provider, boolean showInDialog) {
        super("Operation_ShowConflictEditor", SVNUIMessages.class, provider);
        this.showInDialog = showInDialog;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = super.getSchedulingRule();
        if (rule instanceof IWorkspaceRoot) {
            return rule;
        }
        IResource[] resources = this.operableData();
        HashSet<ISchedulingRule> ruleSet = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            ruleSet.add(SVNResourceRuleFactory.INSTANCE.refreshRule((IResource)resources[i].getParent()));
            ++i;
        }
        return new MultiRule((ISchedulingRule[])ruleSet.toArray(new IResource[ruleSet.size()]));
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] conflictingResources = this.operableData();
        int i = 0;
        while (i < conflictingResources.length && !monitor.isCanceled()) {
            final IResource current = conflictingResources[i];
            if (current.getType() == 1) {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        ShowConflictEditorOperation.this.showEditorFor((IFile)current, monitor);
                    }
                }, monitor, conflictingResources.length);
            }
            ++i;
        }
    }

    protected void showEditorFor(IFile resource, IProgressMonitor monitor) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation location = storage.getRepositoryLocation((IResource)resource);
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNChangeStatus[] status = SVNUtility.status((ISVNConnector)proxy, (String)FileUtility.getWorkingCopyPath((IResource)resource), (int)0, (long)0L, (ISVNProgressMonitor)new SVNNullProgressMonitor());
            if (status.length == 1) {
                IContainer parent = resource.getParent();
                parent.refreshLocal(1, monitor);
                IFile local = null;
                if (status[0].conflictWorking != null && !"".equals(status[0].conflictWorking) && !(local = parent.getFile((IPath)new Path(status[0].conflictWorking))).exists()) {
                    local = null;
                }
                local = local == null ? resource : local;
                IFile remote = parent.getFile((IPath)new Path(status[0].conflictNew));
                IFile ancestor = parent.getFile((IPath)new Path(status[0].conflictOld));
                RunExternalCompareOperation.DetectExternalCompareOperationHelper detectCompareEditorHelper = new RunExternalCompareOperation.DetectExternalCompareOperationHelper((IResource)resource, SVNTeamDiffViewerPage.loadDiffViewerSettings(), false);
                detectCompareEditorHelper.execute(monitor);
                DiffViewerSettings.ExternalProgramParameters externalProgramParams = detectCompareEditorHelper.getExternalProgramParameters();
                if (externalProgramParams != null) {
                    this.openExternalEditor(resource, local, remote, ancestor, externalProgramParams, monitor);
                } else {
                    this.openEclipseEditor(resource, local, remote, ancestor, monitor);
                }
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected void openExternalEditor(IFile target, IFile left, IFile right, IFile ancestor, DiffViewerSettings.ExternalProgramParameters externalProgramParams, IProgressMonitor monitor) throws Exception {
        String targetFile = FileUtility.getWorkingCopyPath((IResource)target);
        String oldFile = FileUtility.getWorkingCopyPath((IResource)ancestor);
        String workingFile = FileUtility.getWorkingCopyPath((IResource)left);
        String newFile = FileUtility.getWorkingCopyPath((IResource)right);
        RunExternalCompareOperation.ExternalCompareOperationHelper compareRunner = new RunExternalCompareOperation.ExternalCompareOperationHelper(oldFile, workingFile, newFile, targetFile, externalProgramParams, false);
        compareRunner.execute(monitor);
    }

    protected void openEclipseEditor(final IFile target, IFile left, IFile right, IFile ancestor, IProgressMonitor monitor) throws Exception {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
        final ConflictingFileEditorInput compare = new ConflictingFileEditorInput(cc, target, left, right, ancestor);
        compare.run(monitor);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (ShowConflictEditorOperation.this.showInDialog) {
                    ComparePanel panel = new ComparePanel(compare, (IResource)target);
                    DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                    dlg.open();
                } else {
                    CompareUI.openCompareEditor((CompareEditorInput)compare);
                }
            }
        });
    }
}

