/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.discovery.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class DiscoveryUiUtil {
    private DiscoveryUiUtil() {
    }

    public static void logAndDisplayStatus(String title, IStatus status) {
        DiscoveryUiUtil.logAndDisplayStatus(null, title, status);
    }

    public static void logAndDisplayStatus(Shell shell, String title, IStatus status) {
        SVNTeamUIPlugin.instance().getLog().log(status);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.getDisplay().isDisposed()) {
            if (shell == null) {
                shell = UIMonitorUtility.getShell();
            }
            DiscoveryUiUtil.displayStatus(shell, title, status, true);
        }
    }

    public static void displayStatus(String title, IStatus status) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.getDisplay().isDisposed()) {
            DiscoveryUiUtil.displayStatus(UIMonitorUtility.getShell(), title, status, false);
        } else {
            SVNTeamUIPlugin.instance().getLog().log(status);
        }
    }

    public static void displayStatus(Shell shell, String title, IStatus status, boolean showLinkToErrorLog) {
        String message = status.getMessage();
        if (showLinkToErrorLog) {
            message = String.valueOf(message) + SVNUIMessages.DiscoveryUi_seeErrorLog;
        }
        switch (status.getSeverity()) {
            case 1: 
            case 8: {
                DiscoveryUiUtil.createDialog(shell, title, message, 2).open();
                break;
            }
            case 2: {
                DiscoveryUiUtil.createDialog(shell, title, message, 4).open();
                break;
            }
            default: {
                DiscoveryUiUtil.createDialog(shell, title, message, 1).open();
            }
        }
    }

    public static MessageDialog createDialog(Shell shell, String title, String message, int type) {
        return new MessageDialog(shell, title, null, message, type, new String[]{IDialogConstants.OK_LABEL}, 0);
    }
}

