/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.crashrecovery.invalidmeta;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.connector.SVNConnectorHelper;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class ValidConnectorsSelectionPanel
extends AbstractDialogPanel {
    protected Combo svnConnectorField;
    protected ISVNConnectorFactory[] factories;
    protected String svnConnector;

    public ValidConnectorsSelectionPanel(IProject project, List validClients) {
        this.dialogTitle = SVNUIMessages.format((String)SVNUIMessages.ValidConnectorsSelectionPanel_Title, (Object[])new String[]{project.getName()});
        this.dialogDescription = SVNUIMessages.ValidConnectorsSelectionPanel_Description;
        this.defaultMessage = SVNUIMessages.ValidConnectorsSelectionPanel_Message;
        this.factories = validClients.toArray(new ISVNConnectorFactory[validClients.size()]);
    }

    public Point getPrefferedSizeImpl() {
        return new Point(500, 60);
    }

    public void postInit() {
        super.postInit();
        this.svnConnector = this.factories[this.svnConnectorField.getSelectionIndex()].getId();
    }

    protected void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.ValidConnectorsSelectionPanel_Clients);
        this.svnConnectorField = new Combo(composite, 8);
        data = new GridData(768);
        this.svnConnectorField.setLayoutData((Object)data);
        Arrays.sort(this.factories, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ISVNConnectorFactory)o1).getName().compareTo(((ISVNConnectorFactory)o2).getName());
            }
        });
        String[] items = new String[this.factories.length];
        int i = 0;
        while (i < items.length) {
            items[i] = SVNConnectorHelper.getConnectorName((ISVNConnectorFactory)this.factories[i]);
            ++i;
        }
        this.svnConnectorField.setItems(items);
        this.svnConnectorField.select(0);
        this.svnConnectorField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidConnectorsSelectionPanel.this.svnConnector = ValidConnectorsSelectionPanel.this.factories[ValidConnectorsSelectionPanel.this.svnConnectorField.getSelectionIndex()].getId();
            }
        });
    }

    protected void cancelChangesImpl() {
    }

    protected void saveChangesImpl() {
        String oldId = CoreExtensionsManager.instance().getSVNConnectorFactory().getId();
        if (!oldId.equals(this.svnConnector)) {
            SVNTeamPreferences.setCoreString(SVNTeamUIPlugin.instance().getPreferenceStore(), "svnconnector", this.svnConnector);
            SVNTeamUIPlugin.instance().savePluginPreferences();
            SVNRemoteStorage.instance().dispose();
        }
    }
}

