/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.event.IResourceSelectionChangeListener;
import org.eclipse.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;
import org.eclipse.team.svn.ui.utility.ColumnedViewerComparator;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ResourceSelectionComposite
extends Composite {
    protected static final ImageDescriptor ERROR_IMAGE_DESC = new OverlayedImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/problem_underlay.gif").createImage(), TeamImages.getImageDescriptor((String)"ovr/error_co.gif"), new Point(9, 9), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.TOP);
    protected static final ImageDescriptor WARNING_IMAGE_DESC = new OverlayedImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/problem_underlay.gif").createImage(), TeamImages.getImageDescriptor((String)"ovr/warning_co.gif"), new Point(9, 9), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.TOP);
    protected static final ImageDescriptor EMPTY_IMAGE_DESC = new OverlayedImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/problem_underlay.gif").createImage(), SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/empty_error.gif"), new Point(9, 9), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.TOP);
    protected static final ImageDescriptor SWITCHED_IMAGE_DESC = new OverlayedImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/problem_underlay.gif").createImage(), SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/switched.gif"), new Point(9, 9), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.TOP);
    protected static final int COLUMN_CHECKBOX = 0;
    protected static final int COLUMN_NAME = 1;
    protected static final int COLUMN_STATUS = 2;
    protected static final int COLUMN_PROPSTATUS = 3;
    protected CheckboxTableViewer tableViewer;
    protected ISelectionChangedListener selectionListener;
    protected IResource[] resources;
    protected IResource[] selectedResources;
    protected IResource[] notSelectedResources;
    protected List selectionChangedListeners;
    protected boolean deselectNewl;
    protected boolean cacheEnabled;
    protected HashSet externalResources = new HashSet();
    protected HashSet userSelectedResources = new HashSet();
    protected Map<ImageDescriptor, Image> images;
    protected Label lblSelectedResourcesNumber;
    protected boolean showCheckBoxesAndButtons;

    public ResourceSelectionComposite(Composite parent, int style, IResource[] resources, boolean selectAll) {
        this(parent, style, resources, selectAll, null);
    }

    public ResourceSelectionComposite(Composite parent, int style, IResource[] resources, boolean selectAll, boolean showCheckBoxesAndButtons) {
        this(parent, style, resources, selectAll, null, showCheckBoxesAndButtons);
    }

    public ResourceSelectionComposite(Composite parent, int style, IResource[] resources, boolean selectAll, IResource[] userSelectedResources) {
        this(parent, style, resources, selectAll, userSelectedResources, true);
    }

    public ResourceSelectionComposite(Composite parent, int style, IResource[] resources, boolean selectAll, IResource[] userSelectedResources, boolean showCheckBoxesAndButtons) {
        super(parent, style);
        this.showCheckBoxesAndButtons = showCheckBoxesAndButtons;
        this.resources = resources;
        this.selectedResources = resources;
        this.notSelectedResources = new IResource[0];
        this.selectionChangedListeners = new ArrayList();
        this.deselectNewl = selectAll;
        this.images = new HashMap<ImageDescriptor, Image>();
        if (userSelectedResources != null) {
            this.userSelectedResources.addAll(Arrays.asList(userSelectedResources));
        }
        IResource[] externals = FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_SWITCHED, (int)0);
        int i = 0;
        while (i < externals.length) {
            this.externalResources.add(externals[i]);
            ++i;
        }
        this.cacheEnabled = CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled();
        this.createControls();
        this.refreshSelection();
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
        super.dispose();
    }

    public IResource[] getSelectedResources() {
        return this.selectedResources;
    }

    public IResource[] getNotSelectedResources() {
        return this.notSelectedResources;
    }

    public List getCurrentSelection() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        return selection.toList();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
        this.tableViewer.setInput((Object)this.resources);
        this.updateSelectedResources();
        this.tableViewer.refresh();
    }

    public void createControls() {
        GridLayout gridLayout = null;
        GridData data = null;
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        int style = 68354;
        Table table = new Table((Composite)this, this.showCheckBoxesAndButtons ? style | 0x20 : style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new CheckboxTableViewer(table);
        data = new GridData(1808);
        this.tableViewer.getTable().setLayoutData((Object)data);
        ResourcesTableComparator comparator = new ResourcesTableComparator((Viewer)this.tableViewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.ResourceSelectionComposite_Resource);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(56, true));
        col.addSelectionListener((SelectionListener)comparator);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.ResourceSelectionComposite_Content);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(12, true));
        if (this.cacheEnabled) {
            col.addSelectionListener((SelectionListener)comparator);
        }
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.ResourceSelectionComposite_Properties);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(12, true));
        if (this.cacheEnabled) {
            col.addSelectionListener((SelectionListener)comparator);
        }
        this.tableViewer.setComparator((ViewerComparator)comparator);
        comparator.setColumnNumber(2);
        this.tableViewer.getTable().setSortColumn(this.tableViewer.getTable().getColumn(2));
        this.tableViewer.getTable().setSortDirection(128);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 1 && element instanceof IAdaptable) {
                    Image image;
                    IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
                    if (adapter == null) {
                        return null;
                    }
                    ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                    if (descriptor == null) {
                        return null;
                    }
                    boolean hasWarning = false;
                    boolean hasError = false;
                    try {
                        IResource currentResource = (IResource)element;
                        IMarker[] markers = currentResource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        int i = 0;
                        while (i < markers.length && !hasError) {
                            Integer severity;
                            Integer n = severity = markers[i] != null ? (Integer)markers[i].getAttribute("severity") : null;
                            if (severity != null) {
                                hasWarning |= severity == 1;
                                hasError |= severity == 2;
                            }
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {}
                    if ((image = ResourceSelectionComposite.this.images.get(descriptor)) == null) {
                        image = descriptor.createImage();
                        ResourceSelectionComposite.this.images.put(descriptor, image);
                    }
                    OverlayedImageDescriptor desc = null;
                    desc = hasError ? new OverlayedImageDescriptor(image, ERROR_IMAGE_DESC, new Point(16, 16), OverlayedImageDescriptor.BOTTOM | OverlayedImageDescriptor.LEFT) : (hasWarning ? new OverlayedImageDescriptor(image, WARNING_IMAGE_DESC, new Point(16, 16), OverlayedImageDescriptor.BOTTOM | OverlayedImageDescriptor.LEFT) : new OverlayedImageDescriptor(image, EMPTY_IMAGE_DESC, new Point(16, 16), OverlayedImageDescriptor.BOTTOM | OverlayedImageDescriptor.LEFT));
                    image = this.createImage(desc);
                    if (ResourceSelectionComposite.this.externalResources.contains(element)) {
                        desc = new OverlayedImageDescriptor(image, SWITCHED_IMAGE_DESC, new Point(16, 16), OverlayedImageDescriptor.BOTTOM | OverlayedImageDescriptor.RIGHT);
                    }
                    image = this.createImage(desc);
                    return image;
                }
                return null;
            }

            protected Image createImage(OverlayedImageDescriptor descriptor) {
                Image image = ResourceSelectionComposite.this.images.get((Object)descriptor);
                if (image == null) {
                    image = descriptor.createImage();
                    ResourceSelectionComposite.this.images.put((ImageDescriptor)descriptor, image);
                }
                return image;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return "";
                }
                IResource resource = (IResource)element;
                if (columnIndex == 1) {
                    String path = resource.getFullPath().toString();
                    return path.startsWith("/") ? path.substring(1) : path;
                }
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                if (columnIndex == 2) {
                    return ResourceSelectionComposite.this.contentStatusAsString(local);
                }
                if (columnIndex == 3) {
                    return ResourceSelectionComposite.this.propertiesStatusAsString(local);
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        this.tableViewer.setInput((Object)this.resources);
        int i = 0;
        while (i < this.resources.length) {
            this.tableViewer.setChecked((Object)this.resources[i], this.isSelectableResource(this.resources[i]));
            ++i;
        }
        this.updateSelectedResources();
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                final IResource resource = (IResource)selection.getFirstElement();
                IResource[] resources = new IResource[]{resource};
                if (selection.size() == 1 && !FileUtility.checkForResourcesPresence((IResource[])resources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY, (int)0)) {
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                            if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                                IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                                remote.setSelectedRevision(CompareResourcesOperation.getRemoteResourceRevisionForCompare(resource));
                                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, true, true));
                            }
                        }
                    });
                }
            }
        });
        if (!this.showCheckBoxesAndButtons) {
            return;
        }
        this.selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceSelectionComposite.this.updateSelectedResources();
                ResourceSelectionComposite.this.fireResourcesSelectionChanged(new ResourceSelectionChangedEvent(ResourceSelectionComposite.this.selectedResources));
                int selectedNumber = ResourceSelectionComposite.this.selectedResources.length;
                ResourceSelectionComposite.this.lblSelectedResourcesNumber.setText(ResourceSelectionComposite.this.resourceNumberToString(selectedNumber));
            }
        };
        this.tableViewer.addSelectionChangedListener(this.selectionListener);
        Composite tComposite = new Composite((Composite)this, 131072);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 3;
        gLayout.marginWidth = 0;
        tComposite.setLayout((Layout)gLayout);
        data = new GridData(768);
        tComposite.setLayoutData((Object)data);
        Button selectButton = new Button(tComposite, 8);
        selectButton.setText(SVNUIMessages.Button_SelectAll);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(selectButton);
        selectButton.setLayoutData((Object)data);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelectionComposite.this.tableViewer.setAllChecked(true);
                Object[] elements = ResourceSelectionComposite.this.tableViewer.getCheckedElements();
                ResourceSelectionComposite.this.selectionListener.selectionChanged(null);
                ResourceSelectionComposite.this.fireResourcesSelectionChanged(new ResourceSelectionChangedEvent(Arrays.asList(elements).toArray(new IResource[elements.length])));
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(tComposite, 8);
        deselectButton.setText(SVNUIMessages.Button_ClearSelection);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(deselectButton);
        deselectButton.setLayoutData((Object)data);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelectionComposite.this.tableViewer.setAllChecked(false);
                ResourceSelectionComposite.this.selectionListener.selectionChanged(null);
                ResourceSelectionComposite.this.fireResourcesSelectionChanged(new ResourceSelectionChangedEvent(new IResource[0]));
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        Composite lComposite = new Composite(tComposite, 0);
        GridLayout lLayout = new GridLayout();
        lLayout.horizontalSpacing = 0;
        lLayout.marginWidth = 0;
        lComposite.setLayout((Layout)lLayout);
        data = new GridData(768);
        lComposite.setLayoutData((Object)data);
        this.lblSelectedResourcesNumber = new Label(lComposite, 131072);
        this.lblSelectedResourcesNumber.setText(this.resourceNumberToString(this.selectedResources.length));
        data = new GridData(768);
        this.lblSelectedResourcesNumber.setLayoutData((Object)data);
    }

    protected String resourceNumberToString(int value) {
        return SVNUIMessages.format((String)SVNUIMessages.ResourceSelectionComposite_Info, (Object[])new String[]{String.valueOf(value), String.valueOf(this.resources.length)});
    }

    protected String contentStatusAsString(ILocalResource local) {
        String status = "";
        if (!"Normal".equals(local.getTextStatus())) {
            status = SVNUtility.getStatusText((String)local.getTextStatus());
            if (local.isCopied()) {
                status = String.valueOf(status) + " (+)";
            }
        }
        if (local.hasTreeConflict() && local.getTreeConflictDescriptor().conflictKind == 0) {
            if (!"".equals(status)) {
                status = String.valueOf(status) + ", ";
            }
            status = String.valueOf(status) + SVNMessages.TreeConflicting;
        }
        return status;
    }

    protected String propertiesStatusAsString(ILocalResource local) {
        String status = "";
        if (IStateFilter.SF_HAS_PROPERTIES_CHANGES.accept(local)) {
            status = SVNUtility.getStatusText((String)local.getPropStatus());
        }
        if (local.hasTreeConflict() && local.getTreeConflictDescriptor().conflictKind == 1) {
            if (!"".equals(status)) {
                status = String.valueOf(status) + ", ";
            }
            status = String.valueOf(status) + SVNMessages.TreeConflicting;
        }
        return status;
    }

    public void addResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void fireResourcesSelectionChanged(ResourceSelectionChangedEvent event) {
        IResourceSelectionChangeListener[] listeners = this.selectionChangedListeners.toArray(new IResourceSelectionChangeListener[this.selectionChangedListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesSelectionChanged(event);
            ++i;
        }
    }

    public void refreshSelection() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean isSelectNewResources = SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.selectNew");
        if (this.deselectNewl && !isSelectNewResources) {
            Object[] elements = this.tableViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource((IResource)elements[i]);
                if (local.getStatus() == "New") {
                    this.tableViewer.setChecked(elements[i], false);
                }
                ++i;
            }
            elements = this.tableViewer.getCheckedElements();
            this.fireResourcesSelectionChanged(new ResourceSelectionChangedEvent(Arrays.asList(elements).toArray(new IResource[elements.length])));
            this.selectionListener.selectionChanged(null);
        }
    }

    public void fireSelectionChanged() {
        this.selectionListener.selectionChanged(null);
    }

    protected void updateSelectedResources() {
        TableItem[] items = this.tableViewer.getTable().getItems();
        ArrayList<Object> checked = new ArrayList<Object>(items.length);
        ArrayList unchecked = new ArrayList();
        int i = 0;
        while (i < items.length) {
            (items[i].getChecked() ? checked : unchecked).add(items[i].getData());
            ++i;
        }
        this.selectedResources = checked.toArray(new IResource[checked.size()]);
        this.notSelectedResources = unchecked.toArray(new IResource[unchecked.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isSelectableResource(IResource resource) {
        if (!this.externalResources.contains(resource)) {
            return true;
        }
        store = SVNTeamUIPlugin.instance().getPreferenceStore();
        if (!SVNTeamPreferences.getBehaviourBoolean(store, "resourceSelection.treatExternalAsLocal")) {
            return true;
        }
        if (!this.userSelectedResources.contains(resource)) ** GOTO lbl11
        return true;
        while (!IStateFilter.SF_INTERNAL_INVALID.accept(localResource = SVNRemoteStorage.instance().asLocalResource(resource)) && (localResource.getChangeMask() & 8) != 0) {
            if (this.userSelectedResources.contains(resource)) {
                return true;
            }
lbl11:
            // 3 sources

            if ((resource = resource.getParent()) != null) continue;
        }
        return false;
    }

    protected class ResourcesTableComparator
    extends ColumnedViewerComparator {
        public ResourcesTableComparator(Viewer tableViewer) {
            super(tableViewer);
        }

        public int compareImpl(Viewer viewer, Object row1, Object row2) {
            if (this.column == 0) {
                return 0;
            }
            IResource rowData1 = (IResource)row1;
            IResource rowData2 = (IResource)row2;
            if (this.column == 1) {
                return this.compareNames(rowData1, rowData2);
            }
            if (!ResourceSelectionComposite.this.cacheEnabled) {
                return 0;
            }
            ILocalResource local1 = SVNRemoteStorage.instance().asLocalResource(rowData1);
            ILocalResource local2 = SVNRemoteStorage.instance().asLocalResource(rowData2);
            if (this.column == 2) {
                String status2;
                String status1 = ResourceSelectionComposite.this.contentStatusAsString(local1);
                int retVal = this.compareStatuses(status1, status2 = ResourceSelectionComposite.this.contentStatusAsString(local2));
                return retVal != 0 ? retVal : this.compareNames(rowData1, rowData2);
            }
            if (this.column == 3) {
                String propStatus1 = ResourceSelectionComposite.this.propertiesStatusAsString(local1);
                String propStatus2 = ResourceSelectionComposite.this.propertiesStatusAsString(local2);
                return ColumnedViewerComparator.compare(propStatus1, propStatus2);
            }
            return 0;
        }

        protected int compareStatuses(String status1, String status2) {
            if (status1 == status2) {
                return 0;
            }
            if (status1 == "New" || status1 == "Ignored") {
                return 1;
            }
            if (status2 == "New" || status2 == "Ignored") {
                return -1;
            }
            return ColumnedViewerComparator.compare(status1, status2);
        }

        protected int compareNames(IResource rowData1, IResource rowData2) {
            boolean cnd1 = rowData1 instanceof IContainer;
            boolean cnd2 = rowData2 instanceof IContainer;
            if (cnd1 && !cnd2) {
                return -1;
            }
            if (cnd2 && !cnd1) {
                return 1;
            }
            String path1 = rowData1.getFullPath().toString();
            String path2 = rowData2.getFullPath().toString();
            return ColumnedViewerComparator.compare(path1, path2);
        }
    }
}

