/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.extension.factory.IReporter;
import org.eclipse.team.svn.ui.extension.factory.IReporterFactory;
import org.eclipse.team.svn.ui.extension.factory.IReportingDescriptor;
import org.eclipse.team.svn.ui.panel.reporting.PreviewErrorReportPanel;
import org.eclipse.team.svn.ui.panel.reporting.PreviewReportPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class ReportingComposite
extends Composite {
    public static final String MAIL_HISTORY = "mailHistory";
    public static final String USER_NAME_HISTORY = "userNameHistory";
    protected UserInputHistory mailHistory;
    protected UserInputHistory userNameHistory;
    protected Combo providersCombo;
    protected Text emailText;
    protected Text nameText;
    protected Text commentText;
    protected Button doNotShowAgainButton;
    protected Button previewButton;
    protected boolean doNotShowAgain;
    protected String reportType;
    protected boolean isError;
    protected String pluginId;
    protected IStatus status;
    protected IReportingDescriptor[] providers;
    protected IReporter reporter;

    public ReportingComposite(Composite parent, String reportType, String pluginId, IStatus status, String optionName, boolean isError, IValidationManager manager) {
        this(parent, reportType, pluginId, status, optionName, isError, manager, false);
    }

    public ReportingComposite(Composite parent, String reportType, String pluginId, IStatus status, String optionName, boolean isError, IValidationManager manager, boolean doNotValidateComment) {
        super(parent, 0);
        this.isError = isError;
        this.reportType = reportType;
        this.pluginId = pluginId;
        this.status = status;
        this.providers = ExtensionsManager.getInstance().getReportingDescriptors();
        this.reporter = ReportingComposite.getDefaultReporter(isError, status);
        this.createControls(optionName, manager, doNotValidateComment);
    }

    public static IReporter getDefaultReporter(boolean isError, IStatus status) {
        IReporter reporter;
        IReportingDescriptor[] providers = ExtensionsManager.getInstance().getReportingDescriptors();
        if (providers.length > 0 && (reporter = ExtensionsManager.getInstance().getReporter(providers[0], isError ? IReporterFactory.ReportType.BUG : IReporterFactory.ReportType.TIP)) != null) {
            reporter.setProblemStatus(status);
            return reporter;
        }
        return null;
    }

    public IReporter getReporter() {
        return this.reporter;
    }

    public boolean isNotShowAgain() {
        return this.doNotShowAgain;
    }

    public void saveChanges() {
        if (this.commentText != null) {
            this.reporter.setUserComment(this.commentText.getText().trim());
        }
        if (this.emailText != null) {
            String email = this.emailText.getText().trim();
            this.reporter.setUserEMail(email);
            if (email.length() > 0) {
                this.mailHistory.addLine(email);
            } else {
                this.mailHistory.clear();
            }
        }
        if (this.nameText != null) {
            String name = this.nameText.getText().trim();
            this.reporter.setUserName(name);
            if (name.length() > 0) {
                this.userNameHistory.addLine(name);
            } else {
                this.userNameHistory.clear();
            }
        }
        this.doNotShowAgain = this.doNotShowAgainButton.getSelection();
    }

    public void cancelChanges() {
        this.doNotShowAgain = this.doNotShowAgainButton.getSelection();
    }

    private void createControls(String optionName, IValidationManager manager, boolean doNotValidateComment) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        if (this.providers.length > 1 || this.reporter == null) {
            Label description1 = new Label((Composite)this, 0);
            data = new GridData();
            description1.setLayoutData((Object)data);
            description1.setText(SVNUIMessages.ReportingComposite_Product);
            this.providersCombo = new Combo((Composite)this, 2056);
            data = new GridData(768);
            this.providersCombo.setLayoutData((Object)data);
            Arrays.sort(this.providers, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    IReportingDescriptor first = (IReportingDescriptor)arg0;
                    IReportingDescriptor second = (IReportingDescriptor)arg1;
                    return first.getProductName().compareTo(second.getProductName());
                }
            });
            String[] names = new String[this.providers.length];
            int i = 0;
            while (i < this.providers.length) {
                names[i] = this.providers[i].getProductName();
                ++i;
            }
            this.providersCombo.setItems(names);
            this.providersCombo.select(0);
            this.providersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectedProviderIdx = ReportingComposite.this.providersCombo.getSelectionIndex();
                    ReportingComposite.this.setReporter(selectedProviderIdx);
                }
            });
        }
        this.mailHistory = new UserInputHistory(MAIL_HISTORY, 1);
        this.userNameHistory = new UserInputHistory(USER_NAME_HISTORY, 1);
        String[] mailName = this.mailHistory.getHistory();
        if (this.providers.length > 1 || this.reporter != null && !this.reporter.isCustomEditorSupported() || this.reporter == null) {
            Label description = new Label((Composite)this, 64);
            data = new GridData(772);
            data.widthHint = 200;
            data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this, this.isError ? 4 : 3);
            data.horizontalSpan = 2;
            description.setLayoutData((Object)data);
            description.setText(this.isError ? SVNUIMessages.ReportingComposite_ErrorHint : SVNUIMessages.ReportingComposite_Hint);
            Label description2 = new Label((Composite)this, 0);
            data = new GridData();
            description2.setLayoutData((Object)data);
            description2.setText(SVNUIMessages.ReportingComposite_EMail);
            this.emailText = new Text((Composite)this, 2048);
            data = new GridData(768);
            this.emailText.setLayoutData((Object)data);
            this.emailText.setFocus();
            if (mailName != null && mailName.length > 0) {
                this.emailText.setText(mailName[0]);
            }
            Label description3 = new Label((Composite)this, 0);
            data = new GridData();
            description3.setLayoutData((Object)data);
            description3.setText(SVNUIMessages.ReportingComposite_Name);
            this.nameText = new Text((Composite)this, 2048);
            data = new GridData(768);
            this.nameText.setLayoutData((Object)data);
            String[] userName = this.userNameHistory.getHistory();
            if (userName != null && userName.length > 0) {
                this.nameText.setText(userName[0]);
            }
            Label commentLabel = new Label((Composite)this, 16384);
            data = new GridData();
            data.horizontalSpan = 2;
            commentLabel.setLayoutData((Object)data);
            commentLabel.setText(SVNUIMessages.ReportingComposite_Comment);
            this.commentText = new Text((Composite)this, 2626);
            data = new GridData(1808);
            data.heightHint = 100;
            data.horizontalSpan = 2;
            this.commentText.setLayoutData((Object)data);
            if (mailName != null && mailName.length > 0) {
                this.commentText.setFocus();
            }
            if (manager != null) {
                manager.attachTo((Control)this.commentText, new AbstractVerifier(){

                    protected String getWarningMessage(Control input) {
                        return null;
                    }

                    protected String getErrorMessage(Control input) {
                        if (ReportingComposite.this.getReporter() == null) {
                            return SVNUIMessages.ReportingComposite_Product_Verifier;
                        }
                        return null;
                    }
                });
                if (!doNotValidateComment) {
                    manager.attachTo((Control)this.commentText, new NonEmptyFieldVerifier(SVNUIMessages.ReportingComposite_Comment_Verifier));
                }
            }
        }
        Composite buttonsComposite = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        buttonsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        buttonsComposite.setLayoutData((Object)data);
        this.doNotShowAgainButton = new Button(buttonsComposite, 32);
        data = new GridData(768);
        this.doNotShowAgainButton.setLayoutData((Object)data);
        this.doNotShowAgainButton.setSelection(false);
        if (optionName != null) {
            this.doNotShowAgainButton.setText(optionName);
        } else {
            this.doNotShowAgainButton.setVisible(false);
        }
        if (this.providers.length > 1 || this.reporter != null && !this.reporter.isCustomEditorSupported() || this.reporter == null) {
            this.previewButton = new Button(buttonsComposite, 8);
            data = new GridData(896);
            this.previewButton.setText(SVNUIMessages.ReportingComposite_Preview);
            data.widthHint = DefaultDialog.computeButtonWidth(this.previewButton);
            this.previewButton.setLayoutData((Object)data);
            this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String name = ReportingComposite.this.nameText.getText().trim();
                    String email = ReportingComposite.this.emailText.getText().trim();
                    ReportingComposite.this.reporter.setUserName(name);
                    ReportingComposite.this.reporter.setUserEMail(email);
                    ReportingComposite.this.reporter.setUserComment(ReportingComposite.this.commentText.getText().trim());
                    ReportingComposite.this.reporter.buildReport();
                    PreviewReportPanel panel = null;
                    if (ReportingComposite.this.isError) {
                        panel = new PreviewErrorReportPanel(ReportingComposite.this.reporter.buildReport());
                    } else {
                        String msg = SVNUIMessages.format((String)SVNUIMessages.ReportingComposite_Preview_Title, (Object[])new String[]{ReportingComposite.this.reportType});
                        panel = new PreviewReportPanel(msg, ReportingComposite.this.reporter.buildReport());
                    }
                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getDisplay().getActiveShell(), panel);
                    dialog.open();
                }
            });
        }
        this.setEnablement();
    }

    protected void setReporter(int selectedProviderIdx) {
        if (this.providers.length > selectedProviderIdx) {
            this.reporter = ExtensionsManager.getInstance().getReporter(this.providers[selectedProviderIdx], this.isError ? IReporterFactory.ReportType.BUG : IReporterFactory.ReportType.TIP);
            if (this.reporter != null) {
                this.reporter.setProblemStatus(this.status);
            }
        }
        this.setEnablement();
    }

    protected void setEnablement() {
        boolean enabled;
        boolean bl = enabled = this.reporter != null && !this.reporter.isCustomEditorSupported();
        if (this.previewButton != null) {
            this.previewButton.setEnabled(enabled);
        }
        if (this.nameText != null) {
            this.nameText.setEnabled(enabled);
        }
        if (this.emailText != null) {
            this.emailText.setEnabled(enabled);
        }
    }
}

