/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.mapping.SVNActiveChangeSetCollector;
import org.eclipse.team.svn.core.operation.IConsoleStream;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.ui.ProjectCloseListener;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.console.SVNConsole;
import org.eclipse.team.svn.ui.discovery.DiscoveryConnectorsHelper;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SVNTeamUIPlugin
extends AbstractUIPlugin {
    private static volatile SVNTeamUIPlugin instance = null;
    private ProjectCloseListener pcListener = new ProjectCloseListener();
    private URL baseUrl;
    private SVNConsole console;
    private ActiveChangeSetManager activeChangeSetManager;

    public SVNTeamUIPlugin() {
        instance = this;
    }

    public static SVNTeamUIPlugin instance() {
        return instance;
    }

    public SVNConsole getConsole() {
        return this.console;
    }

    public IConsoleStream getConsoleStream() {
        return this.console == null ? null : this.console.getConsoleStream();
    }

    public ImageDescriptor getImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(this.baseUrl, path));
        }
        catch (MalformedURLException e) {
            LoggedOperation.reportError((String)SVNUIMessages.getErrorString("Error_GetImageDescriptor"), (Throwable)e);
            return null;
        }
    }

    public String getVersionString() {
        return (String)this.getBundle().getHeaders().get("Bundle-Version");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getModelCangeSetManager();
        SVNTeamPreferences.setDefaultValues(this.getPreferenceStore());
        Preferences corePreferences = SVNTeamPlugin.instance().getPluginPreferences();
        String connector = corePreferences.getString("svnconnector").trim();
        if (connector.length() != 0) {
            SVNTeamPreferences.setCoreString(this.getPreferenceStore(), "svnconnector", connector);
            corePreferences.setValue("svnconnector", "");
            SVNTeamPlugin.instance().savePluginPreferences();
        }
        this.baseUrl = context.getBundle().getEntry("/");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.pcListener, 6);
        this.console = new SVNConsole();
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean("firstStartup")) {
            PlatformUI.getWorkbench().getDecoratorManager().setEnabled("org.eclipse.team.svn.ui.decorator.SVNLightweightDecorator", true);
            store.setValue("firstStartup", false);
        }
        this.discoveryConnectors();
    }

    protected void discoveryConnectors() {
        Job job = new Job(SVNUIMessages.Operation_DiscoveryConnectors){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DiscoveryConnectorsHelper discovery = new DiscoveryConnectorsHelper();
                    discovery.run(monitor);
                }
                catch (Throwable t) {
                    LoggedOperation.reportError((String)SVNUIMessages.Operation_DiscoveryConnectors_Error, (Throwable)t);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        this.console.shutdown();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.pcListener);
        if (this.activeChangeSetManager != null) {
            this.activeChangeSetManager.dispose();
        }
        super.stop(context);
    }

    public synchronized ActiveChangeSetManager getModelCangeSetManager() {
        if (this.activeChangeSetManager == null) {
            this.activeChangeSetManager = new SVNActiveChangeSetCollector((Subscriber)UpdateSubscriber.instance());
        }
        return this.activeChangeSetManager;
    }
}

