/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggedOperation
implements IActionOperation {
    protected IActionOperation op;

    public LoggedOperation(IActionOperation op) {
        this.op = op;
    }

    @Override
    public final IActionOperation run(IProgressMonitor monitor) {
        IStatus status = this.op.run(monitor).getStatus();
        if (status.getSeverity() != 0) {
            this.handleError(status);
        }
        return this.op;
    }

    @Override
    public int getOperationWeight() {
        return 1;
    }

    @Override
    public IConsoleStream getConsoleStream() {
        return this.op.getConsoleStream();
    }

    @Override
    public void setConsoleStream(IConsoleStream stream) {
        this.op.setConsoleStream(stream);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.op.getSchedulingRule();
    }

    @Override
    public String getOperationName() {
        return this.op.getOperationName();
    }

    @Override
    public String getId() {
        return this.op.getId();
    }

    @Override
    public Class<? extends NLS> getMessagesClass() {
        return this.op.getMessagesClass();
    }

    @Override
    public final IStatus getStatus() {
        return this.op.getStatus();
    }

    @Override
    public int getExecutionState() {
        return this.op.getExecutionState();
    }

    public static void reportError(String where, Throwable t) {
        String errMessage = SVNMessages.format(SVNMessages.Operation_Error_LogHeader, new String[]{where});
        MultiStatus status = new MultiStatus("org.eclipse.team.svn.core.svnnature", 0, errMessage, null);
        Status st = new Status(4, "org.eclipse.team.svn.core.svnnature", 0, String.valueOf(status.getMessage()) + ": " + t.getMessage(), t);
        status.merge((IStatus)st);
        LoggedOperation.logError((IStatus)status);
    }

    protected void handleError(IStatus errorStatus) {
        if (!errorStatus.isMultiStatus()) {
            Throwable ex = errorStatus.getException();
            if (!(ex instanceof SVNConnectorCancelException) && !(ex instanceof ActivityCancelledException)) {
                LoggedOperation.logError(errorStatus);
            }
            return;
        }
        IStatus[] children = errorStatus.getChildren();
        ArrayList<IStatus> statusesWithoutCancel = new ArrayList<IStatus>();
        int i = 0;
        while (i < children.length) {
            Throwable exception = children[i].getException();
            if (!(exception instanceof SVNConnectorCancelException) && !(exception instanceof ActivityCancelledException)) {
                statusesWithoutCancel.add(children[i]);
            }
            ++i;
        }
        if (statusesWithoutCancel.size() > 0) {
            MultiStatus newStatus = new MultiStatus(errorStatus.getPlugin(), errorStatus.getCode(), statusesWithoutCancel.toArray(new IStatus[statusesWithoutCancel.size()]), errorStatus.getMessage(), errorStatus.getException());
            LoggedOperation.logError((IStatus)newStatus);
        }
    }

    protected static void logError(IStatus errorStatus) {
        SVNTeamPlugin.instance().getLog().log(errorStatus);
    }
}

