/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.operation.BaseFetchOperation;
import org.eclipse.team.svn.revision.graph.operation.CheckRepositoryConnectionOperation;

public class FetchNewRevisionsOperation
extends BaseFetchOperation {
    public FetchNewRevisionsOperation(IRepositoryResource resource, CheckRepositoryConnectionOperation checkConnectionOp, RepositoryCache repositoryCache) {
        super("Operation_FetchNewRevisions", resource, checkConnectionOp, repositoryCache);
    }

    protected void prepareData(IProgressMonitor monitor) throws Exception {
        RepositoryCacheInfo cacheInfo = this.repositoryCache.getCacheInfo();
        this.startRevision = cacheInfo.getLastProcessedRevision() + 1L;
        this.endRevision = this.checkConnectionOp.getLastRepositoryRevision();
        boolean bl = this.canRun = this.checkConnectionOp.getLastRepositoryRevision() > cacheInfo.getLastProcessedRevision();
        if (this.canRun) {
            cacheInfo.setSkippedRevisions(this.startRevision, this.endRevision);
            cacheInfo.setLastProcessedRevision(this.endRevision);
            cacheInfo.save();
            this.repositoryCache.expandRevisionsCount(this.endRevision);
        }
    }
}

