/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.layout;

import java.util.ArrayList;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.layout.AbstractLayoutCommand;
import org.eclipse.team.svn.revision.graph.graphic.layout.ColumnData;

public class SetYCommand
extends AbstractLayoutCommand {
    protected ArrayList<ColumnData> columnsData = new ArrayList();

    public SetYCommand(RevisionNode startNode) {
        super(startNode);
    }

    public void run() {
        RevisionNodeData nodeData = new RevisionNodeData(this.startNode, true);
        while (nodeData.node != null) {
            RevisionNodeData nextNodeToProcessData;
            boolean hasOnlyRename;
            RevisionNode[] copiedTo = nodeData.node.getCopiedTo();
            boolean bl = hasOnlyRename = copiedTo.length == 1 && copiedTo[0].getAction() == PathRevision.RevisionNodeAction.RENAME;
            if (copiedTo.length == 0 || hasOnlyRename) {
                if (nodeData.canAddNodeToColumnData) {
                    ColumnData columnData = this.getColumnStructure(nodeData.node);
                    columnData.addNode(nodeData.node);
                }
                nextNodeToProcessData = hasOnlyRename ? new RevisionNodeData(copiedTo[0], true) : (nodeData.node.getNext() != null ? new RevisionNodeData(nodeData.node.getNext(), true) : this.findNextNodeToProcess(nodeData.node));
            } else {
                RevisionNode topNode = this.goTopOnMostRightDirection(nodeData.node, nodeData.canAddNodeToColumnData);
                nextNodeToProcessData = this.findNextNodeToProcess(topNode);
            }
            this.updateColumnData();
            nodeData = nextNodeToProcessData;
        }
    }

    protected void updateColumnData() {
        int maxDiff = 0;
        int offsetForMax = 0;
        for (ColumnData columnData : this.columnsData) {
            int diff;
            if (columnData == null || columnData.getCurrentBottom() == 0 && columnData.getCurrentTop() == 0 || (diff = columnData.getTop() - columnData.getCurrentBottom()) < 0) continue;
            RevisionNode[] currentNodes = columnData.getCurrentNodes();
            RevisionNode bottomCurrentNode = currentNodes[0];
            int offset = bottomCurrentNode.getPrevious() != null || bottomCurrentNode.getAction() == PathRevision.RevisionNodeAction.RENAME || bottomCurrentNode.getCopiedFrom() != null && bottomCurrentNode.getCopiedFrom().getAction() == PathRevision.RevisionNodeAction.RENAME || bottomCurrentNode.getPrevious() == null && bottomCurrentNode.getCopiedFrom() == null ? (diff == 0 ? 0 : 3) : this.getHeightOffset(columnData) + 6;
            if (diff < maxDiff) continue;
            maxDiff = diff;
            offsetForMax = offset;
        }
        for (ColumnData columnData : this.columnsData) {
            if (columnData == null || columnData.getCurrentBottom() == 0 && columnData.getCurrentTop() == 0) continue;
            columnData.increase(maxDiff + offsetForMax);
            columnData.resetCurrentValues();
        }
    }

    protected RevisionNode goTopOnMostRightDirection(RevisionNode node, boolean isAddCurrentNodeToColumnData) {
        RevisionNode topNode = node;
        boolean isFirst = true;
        while (true) {
            if (!isFirst || isAddCurrentNodeToColumnData) {
                ColumnData columnData = this.getColumnStructure(topNode);
                columnData.addNode(topNode);
            }
            isFirst = false;
            RevisionNode[] copyToNodes = topNode.getCopiedTo();
            if (copyToNodes.length > 0) {
                int i = 0;
                while (i < copyToNodes.length - 1) {
                    RevisionNode copyTo = copyToNodes[i];
                    ColumnData copyToColumnData = this.getColumnStructure(copyTo);
                    copyToColumnData.addNode(copyTo);
                    ++i;
                }
                topNode = copyToNodes[copyToNodes.length - 1];
                continue;
            }
            if (topNode.getNext() == null) break;
            topNode = topNode.getNext();
        }
        return topNode;
    }

    protected int getHeightOffset(ColumnData columnData) {
        int heightOffset = 0;
        RevisionNode[] columnNodes = columnData.getCurrentNodes();
        if (columnNodes.length > 0 && columnNodes[0].getCopiedFrom() != null) {
            heightOffset = columnNodes[0].getCopiedFrom().getHeight();
        }
        return heightOffset;
    }

    protected RevisionNodeData findNextNodeToProcess(RevisionNode topNode) {
        RevisionNode tmpNode = topNode;
        while (tmpNode != null) {
            if (tmpNode.getCopiedFrom() != null) {
                RevisionNode copiedFrom = tmpNode.getCopiedFrom();
                RevisionNode[] copyToNodes = copiedFrom.getCopiedTo();
                if (copyToNodes.length > 1) {
                    boolean isFoundCurrentNode = false;
                    int i = copyToNodes.length - 1;
                    while (i >= 0) {
                        if (isFoundCurrentNode) {
                            return new RevisionNodeData(copyToNodes[i], false);
                        }
                        if (copyToNodes[i].equals(tmpNode)) {
                            isFoundCurrentNode = true;
                        }
                        --i;
                    }
                }
                if (copiedFrom.getNext() != null) {
                    return new RevisionNodeData(copiedFrom.getNext(), true);
                }
                tmpNode = copiedFrom;
                continue;
            }
            tmpNode = tmpNode.getPrevious();
        }
        return new RevisionNodeData(null, false);
    }

    protected ColumnData getColumnStructure(RevisionNode node) {
        ColumnData columnStructure;
        int index = node.getX();
        if (index >= this.columnsData.size() || this.columnsData.get(index) == null) {
            if (index >= this.columnsData.size()) {
                int max = index - this.columnsData.size() + 1;
                int i = 0;
                while (i < max) {
                    this.columnsData.add(null);
                    ++i;
                }
            }
            columnStructure = new ColumnData(index);
            this.columnsData.add(index, columnStructure);
        } else {
            columnStructure = this.columnsData.get(index);
        }
        return columnStructure;
    }

    public int getMaxY() {
        int maxY = -1;
        for (ColumnData data : this.columnsData) {
            if (data == null) continue;
            int n = maxY = data.getTop() > maxY ? data.getTop() : maxY;
        }
        return maxY;
    }

    protected static class RevisionNodeData {
        public final RevisionNode node;
        public final boolean canAddNodeToColumnData;

        public RevisionNodeData(RevisionNode node, boolean isAddCurrentNodeToColumnData) {
            this.node = node;
            this.canAddNodeToColumnData = isAddCurrentNodeToColumnData;
        }
    }
}

