/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.layout;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionGraphEditPart;
import org.eclipse.team.svn.revision.graph.graphic.layout.AbstractLayoutCommand;

public abstract class AbstractGraphLayoutManager
extends AbstractLayout {
    protected RevisionGraphEditPart graphPart;

    public AbstractGraphLayoutManager(RevisionGraphEditPart graphPart) {
        this.graphPart = graphPart;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    public void layout(IFigure container) {
        TimeMeasure layoutMeasure = new TimeMeasure("Layout");
        for (RevisionEditPart editPart : this.graphPart.getChildren()) {
            Dimension size = editPart.getRevisionFigure().getPreferredSize(-1, -1);
            RevisionNode node = editPart.getCastedModel();
            node.setSize(size.width, size.height);
        }
        RevisionNode startNode = this.graphPart.getCastedModel().getCurrentStartNode();
        if (startNode != null) {
            AbstractLayoutCommand[] layoutCommands;
            AbstractLayoutCommand[] abstractLayoutCommandArray = layoutCommands = this.getLayoutCommands(startNode);
            int n = layoutCommands.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLayoutCommand command = abstractLayoutCommandArray[n2];
                command.run();
                ++n2;
            }
        }
        this.graphPart.applyLayoutResults();
        layoutMeasure.end();
    }

    protected abstract AbstractLayoutCommand[] getLayoutCommands(RevisionNode var1);
}

