/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.figure.RevisionFigure;
import org.eclipse.team.svn.ui.utility.DateFormatter;

public class RevisionTooltipFigure
extends Figure {
    protected final RevisionNode revisionNode;
    protected Label pathText;
    protected Label authorText;
    protected Label dateText;
    protected Label copyText;
    protected Label commentText;

    public RevisionTooltipFigure(RevisionNode revisionNode) {
        this.revisionNode = revisionNode;
        this.createControls();
        this.initControls();
        this.setBorder((Border)new LineBorder(ColorConstants.white));
    }

    protected void createControls() {
        ToolbarLayout parentLayout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)parentLayout);
        Figure parent = new Figure();
        this.add((IFigure)parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayoutManager((LayoutManager)layout);
        this.pathText = new Label();
        parent.add((IFigure)this.pathText);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        layout.setConstraint((IFigure)this.pathText, (Object)data);
        Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        this.pathText.setFont(boldFont);
        Label authorLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_Author);
        parent.add((IFigure)authorLabel);
        data = new GridData();
        layout.setConstraint((IFigure)authorLabel, (Object)data);
        this.authorText = new Label();
        parent.add((IFigure)this.authorText);
        layout.setConstraint((IFigure)this.authorText, (Object)new GridData());
        Label dateLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_Date);
        parent.add((IFigure)dateLabel);
        data = new GridData();
        layout.setConstraint((IFigure)dateLabel, (Object)data);
        this.dateText = new Label();
        parent.add((IFigure)this.dateText);
        layout.setConstraint((IFigure)this.dateText, (Object)new GridData());
        if (this.revisionNode.getCopiedFrom() != null) {
            Label copyLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_CopiedFrom);
            parent.add((IFigure)copyLabel);
            data = new GridData();
            layout.setConstraint((IFigure)copyLabel, (Object)data);
            this.copyText = new Label();
            parent.add((IFigure)this.copyText);
            layout.setConstraint((IFigure)this.copyText, (Object)new GridData());
        }
        Label commentLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_Comment);
        parent.add((IFigure)commentLabel);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        layout.setConstraint((IFigure)commentLabel, (Object)data);
        this.commentText = new Label();
        parent.add((IFigure)this.commentText);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        layout.setConstraint((IFigure)this.commentText, (Object)data);
    }

    protected void initControls() {
        String comment;
        this.pathText.setIcon(RevisionFigure.getRevisionNodeIcon(this.revisionNode));
        this.pathText.setText(String.valueOf(this.revisionNode.getPath()) + "@" + this.revisionNode.getRevision());
        String author = this.revisionNode.getAuthor();
        this.authorText.setText(author == null || author.length() == 0 ? SVNMessages.SVNInfo_NoAuthor : author);
        long date = this.revisionNode.getDate();
        this.dateText.setText(date == 0L ? SVNMessages.SVNInfo_NoDate : DateFormatter.formatDate((long)date));
        if (this.revisionNode.getCopiedFrom() != null) {
            RevisionNode copiedFrom = this.revisionNode.getCopiedFrom();
            this.copyText.setText(String.valueOf(copiedFrom.getPath()) + "@" + copiedFrom.getRevision());
        }
        this.commentText.setText((comment = this.revisionNode.getMessage()) == null || comment.length() == 0 ? SVNMessages.SVNInfo_NoComment : comment);
    }
}

