/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditor;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.OpenFileAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.OpenFileWithAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.OpenFileWithExternalAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.OpenFileWithInplaceAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionGraphEditPart;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class RevisionGraphContextMenuManager
extends ContextMenuProvider {
    public static final String GROUP_OPEN = "open";
    public static final String GROUP_COMPARE = "compare";
    public static final String GROUP_1 = "group1";
    public static final String GROUP_2 = "group2";
    public static final String GROUP_3 = "group3";
    protected ActionRegistry actionRegistry;
    protected RevisionGraphEditor graphEditor;

    public RevisionGraphContextMenuManager(EditPartViewer viewer, RevisionGraphEditor graphEditor, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
        this.graphEditor = graphEditor;
    }

    public void buildContextMenu(IMenuManager menu) {
        IRepositoryResource graphCalledResource = ((RevisionGraphEditPart)this.getViewer().getContents()).getCastedModel().getRepositoryResource();
        boolean isGraphCalledOnFile = graphCalledResource instanceof IRepositoryFile;
        if (isGraphCalledOnFile) {
            menu.add((IContributionItem)new Separator(GROUP_OPEN));
        }
        menu.add((IContributionItem)new Separator(GROUP_COMPARE));
        menu.add((IContributionItem)new Separator(GROUP_1));
        menu.add((IContributionItem)new Separator(GROUP_2));
        menu.add((IContributionItem)new Separator(GROUP_3));
        menu.add((IContributionItem)new Separator("additions"));
        List editParts = this.getViewer().getSelectedEditParts();
        ArrayList<RevisionEditPart> revisionEditParts = new ArrayList<RevisionEditPart>();
        for (EditPart editPart : editParts) {
            if (!(editPart instanceof RevisionEditPart)) continue;
            revisionEditParts.add((RevisionEditPart)editPart);
        }
        if (isGraphCalledOnFile) {
            String resourceName = null;
            if (revisionEditParts.size() == 1) {
                IRepositoryResource selectedResource = BaseRevisionGraphAction.convertToResource((RevisionEditPart)revisionEditParts.get(0));
                resourceName = selectedResource.getName();
            }
            IAction action = this.actionRegistry.getAction((Object)"Open");
            menu.appendToGroup(GROUP_OPEN, action);
            action.setImageDescriptor(resourceName != null ? SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getImageDescriptor(resourceName) : null);
            MenuManager sub = new MenuManager(SVNUIMessages.HistoryView_OpenWith, "graphOpenWithMenu");
            sub.add((IContributionItem)new Separator("additions"));
            sub.add((IContributionItem)new Separator("nonDefaultTextEditors"));
            if (resourceName != null) {
                IEditorDescriptor[] editors = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getEditors(resourceName);
                int i = 0;
                while (i < editors.length) {
                    if (!editors[i].getId().equals("org.eclipse.ui.DefaultTextEditor")) {
                        this.addMenuItem(this.getViewer(), sub, editors[i].getLabel(), new OpenFileWithAction((IWorkbenchPart)this.graphEditor, editors[i].getId(), false));
                    }
                    ++i;
                }
            }
            sub.add((IContributionItem)new Separator("variousEditors"));
            this.addMenuItem(this.getViewer(), sub, SVNUIMessages.HistoryView_TextEditor, new OpenFileWithAction((IWorkbenchPart)this.graphEditor));
            this.addMenuItem(this.getViewer(), sub, SVNUIMessages.HistoryView_SystemEditor, new OpenFileWithExternalAction((IWorkbenchPart)this.graphEditor));
            this.addMenuItem(this.getViewer(), sub, SVNUIMessages.HistoryView_InplaceEditor, new OpenFileWithInplaceAction((IWorkbenchPart)this.graphEditor));
            this.addMenuItem(this.getViewer(), sub, SVNUIMessages.HistoryView_DefaultEditor, new OpenFileAction((IWorkbenchPart)this.graphEditor));
            menu.appendToGroup(GROUP_OPEN, (IContributionItem)sub);
        }
        IAction action = this.actionRegistry.getAction((Object)"CompareWithEachOther");
        menu.appendToGroup(GROUP_COMPARE, action);
        action = this.actionRegistry.getAction((Object)"CompareWithHead");
        menu.appendToGroup(GROUP_COMPARE, action);
        action = this.actionRegistry.getAction((Object)"CompareWithPrevious");
        menu.appendToGroup(GROUP_COMPARE, action);
        action = this.actionRegistry.getAction((Object)"ShowHistory");
        menu.appendToGroup(GROUP_1, action);
        action = this.actionRegistry.getAction((Object)"ShowProperties");
        menu.appendToGroup(GROUP_1, action);
        action = this.actionRegistry.getAction((Object)"CompareProperties");
        menu.appendToGroup(GROUP_1, action);
        if (isGraphCalledOnFile) {
            action = this.actionRegistry.getAction((Object)"ShowAnnotation");
            menu.appendToGroup(GROUP_1, action);
        }
        action = this.actionRegistry.getAction((Object)"Export");
        menu.appendToGroup(GROUP_2, action);
        action = this.actionRegistry.getAction((Object)"CreatePatch");
        menu.appendToGroup(GROUP_2, action);
        action = this.actionRegistry.getAction((Object)"Extract");
        menu.appendToGroup(GROUP_2, action);
        action = this.actionRegistry.getAction((Object)"CreateBranch");
        menu.appendToGroup(GROUP_3, action);
        action = this.actionRegistry.getAction((Object)"CreateTag");
        menu.appendToGroup(GROUP_3, action);
        action = this.actionRegistry.getAction((Object)"AddRevisionLinks");
        menu.appendToGroup(GROUP_3, action);
    }

    protected Action addMenuItem(EditPartViewer viewer, MenuManager menuManager, String label, SelectionAction action) {
        action.setText(label);
        action.setToolTipText(label);
        menuManager.add((IAction)action);
        action.update();
        return action;
    }
}

