/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.team.svn.revision.graph.NodeConnections;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.graphic.ChangesNotifier;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionNode
extends NodeConnections<RevisionNode> {
    private final PathRevision pathRevision;
    private final RevisionRootNode rootNode;
    protected final ChangesNotifier changesNotifier;
    protected boolean isFiltered;
    protected boolean isNextCollapsed;
    protected boolean isPreviousCollapsed;
    protected boolean isCopiedFromCollapsed;
    protected boolean isCopiedToCollapsed;
    protected boolean isRenameCollapsed;
    protected int width;
    protected int height;
    protected int x;
    protected int y;

    public RevisionNode(PathRevision pathRevision, RevisionRootNode rootNode) {
        this.pathRevision = pathRevision;
        this.rootNode = rootNode;
        this.changesNotifier = new ChangesNotifier();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public RevisionNode getNext() {
        if (this.isNextCollapsed) {
            return null;
        }
        RevisionNode node = this;
        while ((node = node.internalGetNext()) != null) {
            if (!node.isFiltered) {
                return node;
            }
            if (!node.isNextCollapsed) continue;
            return null;
        }
        return null;
    }

    public RevisionNode internalGetNext() {
        return (RevisionNode)super.getNext();
    }

    @Override
    public RevisionNode getPrevious() {
        if (this.isPreviousCollapsed) {
            return null;
        }
        RevisionNode node = this;
        while ((node = node.internalGetPrevious()) != null) {
            if (!node.isFiltered) {
                return node;
            }
            if (!node.isPreviousCollapsed) continue;
            return null;
        }
        return null;
    }

    public RevisionNode internalGetPrevious() {
        return (RevisionNode)super.getPrevious();
    }

    public RevisionNode[] getCopiedTo(RevisionNode[] a) {
        return this.getCopiedTo();
    }

    public RevisionNode[] getCopiedTo() {
        return this.getCopiedToAsCollection().toArray(new RevisionNode[0]);
    }

    @Override
    public Collection<RevisionNode> getCopiedToAsCollection() {
        if (this.isCopiedToCollapsed && this.isRenameCollapsed) {
            return Collections.emptyList();
        }
        LinkedList<RevisionNode> result = new LinkedList<RevisionNode>();
        Collection<RevisionNode> copiedTo = this.internalGetCopiedToAsCollection();
        for (RevisionNode node : copiedTo) {
            boolean isRename;
            if (node.isFiltered) continue;
            boolean bl = isRename = node.getAction() == PathRevision.RevisionNodeAction.RENAME;
            if (!isRename && !this.isCopiedToCollapsed) {
                result.add(node);
                continue;
            }
            if (!isRename || this.isRenameCollapsed) continue;
            result.addFirst(node);
        }
        return result;
    }

    public Collection<RevisionNode> internalGetCopiedToAsCollection() {
        return super.getCopiedToAsCollection();
    }

    @Override
    public RevisionNode getCopiedFrom() {
        if (this.isCopiedFromCollapsed) {
            return null;
        }
        RevisionNode copiedFrom = this.internalGetCopiedFrom();
        return copiedFrom != null ? (copiedFrom.isFiltered ? null : copiedFrom) : null;
    }

    public RevisionNode internalGetCopiedFrom() {
        return (RevisionNode)super.getCopiedFrom();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changesNotifier.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changesNotifier.removePropertyChangeListener(listener);
    }

    public void refreshConnections() {
        this.changesNotifier.firePropertyChange("refreshNodeConnections", null, this);
    }

    public String getPath() {
        return this.rootNode.getRepositoryCache().getPathStorage().getPath(this.pathRevision.getPathIndex());
    }

    public PathRevision.ReviosionNodeType getType() {
        return this.pathRevision.type;
    }

    public PathRevision.RevisionNodeAction getAction() {
        return this.pathRevision.action;
    }

    public long getRevision() {
        return this.pathRevision.getRevision();
    }

    public String getMessage() {
        int messageIndex = this.pathRevision.getMessageIndex();
        String message = messageIndex != -1 ? this.rootNode.getRepositoryCache().getMessageStorage().getMessage(messageIndex) : null;
        return message;
    }

    public String getAuthor() {
        int authorIndex = this.pathRevision.getAuthorIndex();
        String author = authorIndex != -1 ? (String)this.rootNode.getRepositoryCache().getAuthorStorage().getValue(authorIndex) : null;
        return author;
    }

    public long getDate() {
        return this.pathRevision.getDate();
    }

    public void setFiltered(boolean isFiltered) {
        this.isFiltered = isFiltered;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public boolean isNextCollapsed() {
        return this.isNextCollapsed;
    }

    public void setNextCollapsed(boolean isNextCollapsed) {
        if (isNextCollapsed) {
            this.rootNode.collapseNext(this);
        } else {
            this.rootNode.expandNext(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetNextCollapsed(boolean isNextCollapsed) {
        this.isNextCollapsed = isNextCollapsed;
    }

    public boolean isPreviousCollapsed() {
        return this.isPreviousCollapsed;
    }

    public void setPreviousCollapsed(boolean isPreviousCollapsed) {
        if (isPreviousCollapsed) {
            this.rootNode.collapsePrevious(this);
        } else {
            this.rootNode.expandPrevious(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetPreviousCollapsed(boolean isPreviousCollapsed) {
        this.isPreviousCollapsed = isPreviousCollapsed;
    }

    public boolean isCopiedToCollapsed() {
        return this.isCopiedToCollapsed;
    }

    public void setCopiedToCollapsed(boolean isCopiedToCollapsed) {
        if (isCopiedToCollapsed) {
            this.rootNode.collapseCopiedTo(this);
        } else {
            this.rootNode.expandCopiedTo(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetCopiedToCollapsed(boolean isCopiedToCollapsed) {
        this.isCopiedToCollapsed = isCopiedToCollapsed;
    }

    public boolean isRenameCollapsed() {
        return this.isRenameCollapsed;
    }

    public void setRenameCollapsed(boolean isRenameCollapsed) {
        if (isRenameCollapsed) {
            this.rootNode.collapseRename(this);
        } else {
            this.rootNode.expandRename(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetRenameCollapsed(boolean isRenameCollapsed) {
        this.isRenameCollapsed = isRenameCollapsed;
    }

    public boolean isCopiedFromCollapsed() {
        return this.isCopiedFromCollapsed;
    }

    public void setCopiedFromCollapsed(boolean isCopiedFromCollapsed) {
        if (isCopiedFromCollapsed) {
            this.rootNode.collapseCopiedFrom(this);
        } else {
            this.rootNode.expandCopiedFrom(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetCopiedFromCollapsed(boolean isCopiedFromCollapsed) {
        this.isCopiedFromCollapsed = isCopiedFromCollapsed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RevisionNode) {
            RevisionNode rNode = (RevisionNode)obj;
            return this.pathRevision.equals(rNode.pathRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.pathRevision.hashCode();
    }

    public String toString() {
        return String.valueOf(this.pathRevision.toString()) + ", location: " + this.x + ", " + this.y + ", size: " + this.width + ", " + this.height;
    }
}

