/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;
import org.eclipse.team.svn.revision.graph.graphic.GraphicalEditor;
import org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditorInput;
import org.eclipse.team.svn.revision.graph.graphic.RevisionGraphOutlinePage;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.team.svn.revision.graph.graphic.actions.AddRevisionLinksAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.ComparePropertiesAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.CompareWithEachOtherAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.CompareWithHeadAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.CompareWithPreviousAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.CreateBranchTagAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.CreatePatchAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.ExportAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.ExtractAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.OpenAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.RevisionGraphContextMenuManager;
import org.eclipse.team.svn.revision.graph.graphic.actions.ShowAnnotationAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.ShowHistoryAction;
import org.eclipse.team.svn.revision.graph.graphic.actions.ShowPropertiesAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.GraphEditPartFactory;
import org.eclipse.team.svn.revision.graph.graphic.editpart.GraphScalableRootEditPart;
import org.eclipse.team.svn.revision.graph.operation.CreateCacheDataOperation;
import org.eclipse.team.svn.revision.graph.operation.CreateRevisionGraphModelOperation;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class RevisionGraphEditor
extends GraphicalEditor {
    protected RevisionGraphOutlinePage outlinePage;

    public RevisionGraphEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        TimeMeasure setContentsMeasure = new TimeMeasure("Set contents");
        viewer.setContents(this.getModel());
        setContentsMeasure.end();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IRepositoryResource resource = ((RevisionGraphEditorInput)input).getResource();
        String partName = SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.RevisionGraphEditor_EditName, (Object[])new Object[]{resource.getName(), resource.getSelectedRevision().toString()});
        this.setPartName(partName);
    }

    public Object getModel() {
        RevisionGraphEditorInput editorInput = (RevisionGraphEditorInput)this.getEditorInput();
        return editorInput.getModel();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        GraphScalableRootEditPart root = new GraphScalableRootEditPart();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        root.getZoomManager().setZoom(1.0);
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)new GraphEditPartFactory());
        Object model = this.getModel();
        if (model instanceof RevisionRootNode) {
            boolean isSimpleMode = true;
            ((RevisionRootNode)model).init(isSimpleMode);
            RevisionGraphContextMenuManager menuManager = new RevisionGraphContextMenuManager((EditPartViewer)viewer, this, this.getActionRegistry());
            viewer.setContextMenu((MenuManager)menuManager);
            this.getSite().registerContextMenu((MenuManager)menuManager, (ISelectionProvider)viewer);
            viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 0x100000E) {
                        RevisionGraphEditor.this.handleRefresh();
                    }
                }
            });
        }
    }

    public void handleRefresh() {
        Object objModel = this.getModel();
        if (!(objModel instanceof RevisionRootNode)) {
            return;
        }
        final RevisionRootNode previousModel = (RevisionRootNode)objModel;
        final IRepositoryResource resource = previousModel.getRepositoryResource();
        CompositeOperation op = new CompositeOperation("Operation_RefreshGraph", SVNRevisionGraphMessages.class);
        CreateCacheDataOperation updateCacheOp = new CreateCacheDataOperation(resource, true);
        op.add((IActionOperation)updateCacheOp);
        final CreateRevisionGraphModelOperation createModelOp = new CreateRevisionGraphModelOperation(resource, updateCacheOp);
        op.add((IActionOperation)createModelOp, new IActionOperation[]{updateCacheOp});
        op.add((IActionOperation)new AbstractActionOperation("Operation_RefreshGraph", SVNRevisionGraphMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                if (createModelOp.getModel() == null) {
                    throw new UnreportableException("Failed to update revision graph, its model is null");
                }
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        GraphicalViewer viewer = RevisionGraphEditor.this.getGraphicalViewer();
                        Control control = null;
                        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
                            RevisionRootNode modelObject = new RevisionRootNode(resource, createModelOp.getModel(), createModelOp.getRepositoryCache());
                            ((RevisionGraphEditorInput)RevisionGraphEditor.this.getEditorInput()).setModel(modelObject);
                            boolean isSimpleMode = previousModel.isSimpleMode();
                            modelObject.init(isSimpleMode);
                            viewer.setContents((Object)modelObject);
                        }
                    }
                });
            }
        }, new IActionOperation[]{createModelOp});
        UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)this, (IActionOperation)op);
    }

    protected RevisionGraphOutlinePage getOutlinePage() {
        if (this.outlinePage == null && this.getGraphicalViewer() != null) {
            this.outlinePage = new RevisionGraphOutlinePage((EditPartViewer)this.getGraphicalViewer());
        }
        return this.outlinePage;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == GraphicalViewer.class || adapter == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (adapter == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (adapter == IContentOutlinePage.class) {
            return new RevisionGraphOutlinePage((EditPartViewer)this.getGraphicalViewer());
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        List selectedActions = this.getSelectionActions();
        BaseRevisionGraphAction action = new ShowHistoryAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new CompareWithEachOtherAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new CompareWithHeadAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new CompareWithPreviousAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new ShowPropertiesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new ComparePropertiesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new ExportAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new CreatePatchAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new ExtractAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new CreateBranchTagAction((IWorkbenchPart)this, 0);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new CreateBranchTagAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new AddRevisionLinksAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new OpenAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
        action = new ShowAnnotationAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectedActions.add(action.getId());
    }

    public GraphicalViewer getViewer() {
        return this.getGraphicalViewer();
    }

    public void dispose() {
        RevisionGraphEditorInput editorInput = (RevisionGraphEditorInput)this.getEditorInput();
        if (editorInput != null) {
            Object model = editorInput.getModel();
            if (model instanceof RevisionRootNode) {
                RevisionRootNode rootNode = (RevisionRootNode)model;
                rootNode.getRepositoryCache().getCacheInfo().disposeRepositoryCache(rootNode.getRepositoryResource());
            }
            editorInput.setModel(null);
        }
        super.dispose();
    }
}

