/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.Inflater;
import org.eclipse.team.svn.revision.graph.cache.BytesUtility;
import org.eclipse.team.svn.revision.graph.cache.CacheRevision;
import org.eclipse.team.svn.revision.graph.cache.MessageStorage;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheWriteHelper;
import org.eclipse.team.svn.revision.graph.cache.StringStorage;

public class RepositoryCacheReadHelper {
    protected final RepositoryCache repositoryCache;

    public RepositoryCacheReadHelper(RepositoryCache repositoryCache) {
        this.repositoryCache = repositoryCache;
    }

    public void load() throws IOException {
        File cacheFile = this.repositoryCache.cacheFile;
        if (!cacheFile.exists()) {
            return;
        }
        DataInputStream bytesReader = new DataInputStream(new FileInputStream(cacheFile));
        Inflater decoder = new Inflater();
        try {
            this.repositoryCache.cacheVersion = bytesReader.readInt();
            this.loadRevisions(bytesReader, decoder);
            this.loadPaths(bytesReader, decoder);
            this.loadAuthors(bytesReader, decoder);
            this.loadMessages(bytesReader, decoder);
        }
        catch (Throwable throwable) {
            try {
                bytesReader.close();
            }
            catch (IOException iOException) {}
            decoder.end();
            throw throwable;
        }
        try {
            bytesReader.close();
        }
        catch (IOException iOException) {}
        decoder.end();
    }

    protected void loadRevisions(DataInput in, Inflater decoder) throws IOException {
        int revisionsCountWithNulls = in.readInt();
        int revisionsCountWithoutNulls = in.readInt();
        int revisionsInBlock = in.readInt();
        int blocksCount = in.readInt();
        this.repositoryCache.revisions = new CacheRevision[revisionsCountWithNulls];
        int i = 0;
        while (i < blocksCount) {
            byte[] blockBytes = BytesUtility.decompressAndRead(in, decoder);
            int revisionsCount = revisionsInBlock;
            if (i == blocksCount - 1) {
                revisionsCount = RepositoryCacheWriteHelper.getRevisionsCountInLastBlock(revisionsCountWithoutNulls, revisionsInBlock);
            }
            this.readRevisionsFromBlock(revisionsCount, blockBytes);
            ++i;
        }
    }

    protected void readRevisionsFromBlock(int revisionsCount, byte[] blockBytes) {
        try {
            DataInputStream bytesIn = new DataInputStream(new ByteArrayInputStream(blockBytes));
            int i = 0;
            while (i < revisionsCount) {
                CacheRevision revisionStructure;
                byte[] revisionBytes = BytesUtility.readBytesWithLength(bytesIn);
                this.repositoryCache.revisions[(int)revisionStructure.revision] = revisionStructure = new CacheRevision(revisionBytes);
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    protected void loadPaths(DataInput in, Inflater decoder) throws IOException {
        this.repositoryCache.pathStorage.load(in, decoder);
    }

    protected void loadAuthors(DataInput in, Inflater decoder) throws IOException {
        byte[] bytes = BytesUtility.decompressAndRead(in, decoder);
        this.repositoryCache.authors = new StringStorage(bytes);
    }

    protected void loadMessages(DataInput in, Inflater decoder) throws IOException {
        byte[] bytes = BytesUtility.decompressAndRead(in, decoder);
        this.repositoryCache.messages = new MessageStorage(bytes);
    }
}

