/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCachesManager;
import org.eclipse.team.svn.revision.graph.preferences.SVNRevisionGraphPreferences;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SVNRevisionGraphPlugin
extends AbstractUIPlugin {
    private static volatile SVNRevisionGraphPlugin instance = null;
    private URL baseUrl;
    protected static List<Resource> disposeOnShutdownResources = new ArrayList<Resource>();
    protected RepositoryCachesManager cachesManager;

    public SVNRevisionGraphPlugin() {
        instance = this;
    }

    public static SVNRevisionGraphPlugin instance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SVNRevisionGraphPreferences.setDefaultValues(this.getPreferenceStore());
        this.baseUrl = context.getBundle().getEntry("/");
        String cachePath = SVNRevisionGraphPreferences.getCacheString(this.getPreferenceStore(), "directory");
        this.cachesManager = new RepositoryCachesManager(new File(cachePath));
    }

    public void stop(BundleContext context) throws Exception {
        if (disposeOnShutdownResources != null) {
            for (Resource resource : disposeOnShutdownResources) {
                if (resource.isDisposed()) continue;
                resource.dispose();
            }
        }
        if (this.cachesManager != null) {
            this.cachesManager.dispose();
        }
        super.stop(context);
    }

    public ImageDescriptor getImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(this.baseUrl, path));
        }
        catch (MalformedURLException e) {
            LoggedOperation.reportError((String)SVNUIMessages.getErrorString((String)"Error_GetImageDescriptor"), (Throwable)e);
            return null;
        }
    }

    public static void disposeOnShutdown(Resource resource) {
        if (resource != null) {
            disposeOnShutdownResources.add(resource);
        }
    }

    public RepositoryCachesManager getRepositoryCachesManager() {
        return this.cachesManager;
    }
}

