/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNRepositoryFile
extends SVNRepositoryResource
implements IRepositoryFile {
    private static final long serialVersionUID = 6042328067024796901L;

    public SVNRepositoryFile(IRepositoryLocation location, String url, SVNRevision selectedRevision) {
        super(location, url, selectedRevision);
    }

    protected void getRevisionImpl(ISVNConnector proxy) throws SVNConnectorException {
        SVNEntry[] entries = SVNUtility.list(proxy, SVNUtility.getEntryRevisionReference(this), 0, -1, 0x200000L, new SVNNullProgressMonitor());
        if (entries != null && entries.length > 0 && entries[0].revision != -1L) {
            this.lastRevision = SVNRevision.fromNumber(entries[0].revision);
            this.setInfo(new IRepositoryResource.Information(entries[0].lock, entries[0].size, entries[0].author, entries[0].date, entries[0].hasProperties));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IRepositoryFile)) {
            return false;
        }
        return super.equals(obj);
    }
}

