/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNAnnotationData;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetResourceAnnotationOperation
extends AbstractRepositoryOperation {
    protected SVNAnnotationData[] annotatedLines;
    protected byte[] content;
    protected boolean includeMerged;

    public GetResourceAnnotationOperation(IRepositoryResource resource) {
        super("Operation_GetAnnotation", new IRepositoryResource[]{resource});
    }

    public boolean getIncludeMerged() {
        return this.includeMerged;
    }

    public void setIncludeMerged(boolean includeMerged) {
        this.includeMerged = includeMerged;
    }

    public IRepositoryResource getRepositoryResource() {
        return this.operableData()[0];
    }

    public SVNAnnotationData[] getAnnotatedLines() {
        return this.annotatedLines;
    }

    public byte[] getContent() {
        return this.content;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        final ArrayList lines = new ArrayList();
        IRepositoryResource resource = this.operableData()[0];
        IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            long options = 0x100000L;
            proxy.annotate(SVNUtility.getEntryReference(resource), SVNRevision.fromNumber(0L), resource.getSelectedRevision(), options |= this.includeMerged ? 524288L : 0L, new ISVNAnnotationCallback(){

                public void annotate(String line, SVNAnnotationData data) {
                    lines.add(data);
                    try {
                        stream.write((String.valueOf(line) + "\n").getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        this.annotatedLines = lines.toArray(new SVNAnnotationData[lines.size()]);
        this.content = stream.toByteArray();
    }

    protected String getShortErrorMessage(Throwable t) {
        if (t instanceof SVNConnectorException && ((SVNConnectorException)t).getErrorId() == 195004) {
            return this.getOperationResource("Error_IsBinary");
        }
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getName()});
    }
}

