/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetLogMessagesOperation
extends AbstractRepositoryOperation {
    protected SVNLogEntry[] msg;
    protected boolean stopOnCopy;
    protected boolean discoverPaths;
    protected SVNRevision startRevision;
    protected SVNRevision endRevision;
    protected long limit;
    protected boolean includeMerged;

    public GetLogMessagesOperation(IRepositoryResource resource) {
        this(resource, false);
    }

    public GetLogMessagesOperation(IRepositoryResource resource, boolean stopOnCopy) {
        super("Operation_GetLogMessages", new IRepositoryResource[]{resource});
        this.stopOnCopy = stopOnCopy;
        this.includeMerged = false;
        this.discoverPaths = true;
        this.limit = 0L;
        this.endRevision = SVNRevision.fromNumber(0L);
    }

    public boolean getIncludeMerged() {
        return this.includeMerged;
    }

    public void setIncludeMerged(boolean includeMerged) {
        this.includeMerged = includeMerged;
    }

    public boolean getStopOnCopy() {
        return this.stopOnCopy;
    }

    public void setStopOnCopy(boolean stopOnCopy) {
        this.stopOnCopy = stopOnCopy;
    }

    public boolean getDiscoverPaths() {
        return this.discoverPaths;
    }

    public void setDiscoverPaths(boolean discoverPaths) {
        this.discoverPaths = discoverPaths;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setStartRevision(SVNRevision revision) {
        this.startRevision = revision;
    }

    public void setEndRevision(SVNRevision revision) {
        this.endRevision = revision;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        if (this.startRevision == null) {
            this.startRevision = resource.getSelectedRevision();
        }
        IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            long options = this.discoverPaths ? 262144L : 0L;
            options |= this.stopOnCopy ? 131072L : 0L;
            this.msg = SVNUtility.logEntries(proxy, SVNUtility.getEntryReference(resource), this.startRevision, this.endRevision, options |= this.includeMerged ? 524288L : 0L, ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, this.limit, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    public SVNLogEntry[] getMessages() {
        return this.msg;
    }

    public IRepositoryResource getResource() {
        return this.operableData()[0];
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getUrl()});
    }
}

