/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class BranchTagOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String destinationUrl;
    protected String message;
    protected ArrayList<IRevisionProvider.RevisionPair> revisionsPairs;

    public BranchTagOperation(String operationName, IRepositoryResource[] resources, IRepositoryResource destination, String message) {
        super("Operation_" + operationName, resources);
        this.destinationUrl = destination.getUrl();
        this.message = message;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        Object[] resources = this.operableData();
        ProgressMonitorUtility.setTaskInfo(monitor, this, FileUtility.getNamesListAsString(resources));
        final IRepositoryLocation location = resources[0].getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            block6: {
                int i;
                block5: {
                    i = 0;
                    if (!true) break block5;
                    if (i >= resources.length) return;
                    if (monitor.isCanceled()) break block6;
                }
                do {
                    Object current = resources[i];
                    final String url2 = SVNUtility.encodeURL(this.destinationUrl);
                    ISVNNotificationCallback notify = new ISVNNotificationCallback(){

                        public void notify(SVNNotification info) {
                            BranchTagOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(info.revision, new String[]{url2}, location));
                            String message = SVNMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                            BranchTagOperation.this.writeToConsole(1, message);
                        }
                    };
                    SVNUtility.addSVNNotifyListener(proxy, notify);
                    this.protectStep(new IUnprotectedOperation((IRepositoryResource)current, proxy, url2){
                        private final /* synthetic */ IRepositoryResource val$current;
                        private final /* synthetic */ ISVNConnector val$proxy;
                        private final /* synthetic */ String val$url2;
                        {
                            this.val$current = iRepositoryResource;
                            this.val$proxy = iSVNConnector;
                            this.val$url2 = string;
                        }

                        public void run(IProgressMonitor monitor) throws Exception {
                            BranchTagOperation.this.writeToConsole(0, "svn copy \"" + this.val$current.getUrl() + "\" \"" + BranchTagOperation.this.destinationUrl + "\" -r " + this.val$current.getSelectedRevision() + " -m \"" + BranchTagOperation.this.message + "\"" + FileUtility.getUsernameParam(this.val$current.getRepositoryLocation().getUsername()) + "\n");
                            SVNEntryRevisionReference[] src = new SVNEntryRevisionReference[]{new SVNEntryRevisionReference(SVNUtility.encodeURL(this.val$current.getUrl()), this.val$current.getPegRevision(), this.val$current.getSelectedRevision())};
                            this.val$proxy.copy(src, this.val$url2, BranchTagOperation.this.message, 32768L, null, new SVNProgressMonitor(BranchTagOperation.this, monitor, null));
                        }
                    }, monitor, resources.length);
                    SVNUtility.removeSVNNotifyListener(proxy, notify);
                    ++i;
                    if (i >= resources.length) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

