/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNConflictDetectionProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractConflictDetectionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class UpdateOperation
extends AbstractConflictDetectionOperation
implements IResourceProvider {
    protected SVNRevision selectedRevision;
    protected boolean doRecursiveUpdate;

    public UpdateOperation(IResource[] resources, boolean doRecursiveUpdate) {
        this(resources, null, doRecursiveUpdate);
    }

    public UpdateOperation(IResourceProvider provider, boolean doRecursiveUpdate) {
        this(provider, null, doRecursiveUpdate);
    }

    public UpdateOperation(IResourceProvider provider, SVNRevision selectedRevision, boolean doRecursiveUpdate) {
        super("Operation_Update", provider);
        this.doRecursiveUpdate = doRecursiveUpdate;
        this.selectedRevision = selectedRevision == null ? SVNRevision.HEAD : selectedRevision;
    }

    public UpdateOperation(IResource[] resources, SVNRevision selectedRevision, boolean doRecursiveUpdate) {
        super("Operation_Update", resources);
        this.selectedRevision = selectedRevision == null ? SVNRevision.HEAD : selectedRevision;
        this.doRecursiveUpdate = doRecursiveUpdate;
    }

    public int getOperationWeight() {
        return 19;
    }

    public IResource[] getResources() {
        return this.getProcessed();
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        this.defineInitialResourceSet(resources);
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        Map<IProject, List<IResource>> wc2Resources = SVNUtility.splitWorkingCopies(resources);
        Iterator<Map.Entry<IProject, List<IResource>>> it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry<IProject, List<IResource>> entry = it.next();
            final IRepositoryLocation location = storage.getRepositoryLocation((IResource)entry.getKey());
            IResource[] wcResources = entry.getValue().toArray(new IResource[0]);
            if (this.doRecursiveUpdate) {
                wcResources = FileUtility.shrinkChildNodes(wcResources);
            } else {
                FileUtility.reorder(wcResources, true);
            }
            final String[] paths = FileUtility.asPathArray(wcResources);
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    UpdateOperation.this.writeToConsole(0, "svn update");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        UpdateOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    UpdateOperation.this.writeToConsole(0, " -r " + UpdateOperation.this.selectedRevision + (UpdateOperation.this.doRecursiveUpdate ? "" : " -N") + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.update(paths, UpdateOperation.this.selectedRevision, ISVNConnector.Depth.unknownOrFiles(UpdateOperation.this.doRecursiveUpdate), 0L, new ConflictDetectionProgressMonitor(UpdateOperation.this, monitor, null));
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNConflictDetectionProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        protected void processConflict(ISVNProgressMonitor.ItemState state) {
            UpdateOperation.this.setUnresolvedConflict(true);
            IResource[] iResourceArray = UpdateOperation.this.getProcessed();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                Path conflictPath = new Path(state.path);
                IPath resourcePath = FileUtility.getResourcePath(res);
                if (resourcePath.isPrefixOf((IPath)conflictPath)) {
                    IResource conflictResource;
                    if (resourcePath.equals((Object)conflictPath)) {
                        UpdateOperation.this.removeProcessed(res);
                    }
                    if ((conflictResource = ResourcesPlugin.getWorkspace().getRoot().findMember(res.getFullPath().append(conflictPath.removeFirstSegments(resourcePath.segmentCount())))) == null) break;
                    UpdateOperation.this.addUnprocessed(conflictResource);
                    break;
                }
                ++n2;
            }
        }
    }
}

