/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.file.AbstractStatusOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RemoteStatusOperation
extends AbstractStatusOperation
implements ISVNNotificationCallback {
    protected Map<String, SVNRevision.Number> pegRevisions = new HashMap<String, SVNRevision.Number>();

    public RemoteStatusOperation(File[] files, boolean recursive) {
        super("Operation_UpdateStatusFile", files, recursive);
    }

    public RemoteStatusOperation(IFileProvider provider, boolean recursive) {
        super("Operation_UpdateStatusFile", provider, recursive);
    }

    public SVNRevision getPegRevision(File change) {
        Path resourcePath = new Path(change.getAbsolutePath());
        for (Map.Entry<String, SVNRevision.Number> entry : this.pegRevisions.entrySet()) {
            Path rootPath = new Path(entry.getKey());
            if (!rootPath.isPrefixOf((IPath)resourcePath)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void notify(SVNNotification info) {
        if (info.revision != -1L) {
            this.pegRevisions.put(info.path, SVNRevision.fromNumber(info.revision));
        }
    }

    protected void reportStatuses(ISVNConnector proxy, ISVNEntryStatusCallback cb, File current, IProgressMonitor monitor, int tasks) {
        SVNUtility.addSVNNotifyListener(proxy, this);
        super.reportStatuses(proxy, cb, current, monitor, tasks);
        SVNUtility.removeSVNNotifyListener(proxy, this);
    }

    protected boolean isRemote() {
        return true;
    }
}

