/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IConsoleStream;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class CompositeOperation
extends AbstractActionOperation
implements IConsoleStream {
    protected List<Pair> operations = new ArrayList<Pair>();
    protected boolean checkWarnings;
    protected int totalWeight;

    public CompositeOperation(String operationName) {
        this(operationName, false);
    }

    public CompositeOperation(String operationName, boolean checkWarnings) {
        super(operationName);
        this.checkWarnings = checkWarnings;
        this.totalWeight = 0;
    }

    public void add(IActionOperation operation) {
        this.add(operation, null);
    }

    public void add(IActionOperation operation, IActionOperation[] dependsOnOperation) {
        operation.setConsoleStream(this);
        this.operations.add(new Pair(operation, dependsOnOperation));
        this.totalWeight += operation.getOperationWeight();
    }

    public void remove(IActionOperation operation) {
        Iterator<Pair> it = this.operations.iterator();
        while (it.hasNext()) {
            Pair pair = it.next();
            if (pair.operation != operation) continue;
            if (operation.getConsoleStream() == this) {
                operation.setConsoleStream(null);
            }
            it.remove();
            this.totalWeight -= operation.getOperationWeight();
            break;
        }
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule retVal = null;
        for (Pair pair : this.operations) {
            retVal = MultiRule.combine(retVal, (ISchedulingRule)pair.operation.getSchedulingRule());
        }
        return retVal;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        Iterator<Pair> it = this.operations.iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Pair pair = it.next();
            boolean errorFound = false;
            if (pair.dependsOnOperation != null) {
                int i = 0;
                while (i < pair.dependsOnOperation.length) {
                    if (pair.dependsOnOperation[i].getStatus().getSeverity() == 4 || this.checkWarnings && pair.dependsOnOperation[i].getStatus().getSeverity() == 2 || pair.dependsOnOperation[i].getExecutionState() == 2) {
                        errorFound = true;
                        break;
                    }
                    ++i;
                }
            }
            if (errorFound) continue;
            ProgressMonitorUtility.doTask(pair.operation, monitor, this.totalWeight, pair.operation.getOperationWeight());
            this.reportStatus(pair.operation.getStatus());
        }
    }

    public void markEnd() {
    }

    public void markStart(String data) {
    }

    public void write(int severity, String data) {
        this.writeToConsole(severity, data);
    }

    public void doComplexWrite(Runnable runnable) {
        this.complexWriteToConsole(runnable);
    }

    public void markCancelled() {
        this.writeCancelledToConsole();
    }

    protected class Pair {
        public IActionOperation operation;
        public IActionOperation[] dependsOnOperation;

        public Pair(IActionOperation operation, IActionOperation[] dependsOnOperation) {
            this.operation = operation;
            this.dependsOnOperation = dependsOnOperation;
        }
    }
}

