/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.svn.core.IConnectedProjectInformation;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamMoveDeleteHook;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.history.SVNFileHistoryProvider;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.HiddenException;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.management.DisconnectOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNTeamProvider
extends RepositoryProvider
implements IConnectedProjectInformation {
    public static final QualifiedName RESOURCE_PROPERTY = new QualifiedName("org.eclipse.team.svn", "resource");
    public static final QualifiedName LOCATION_PROPERTY = new QualifiedName("org.eclipse.team.svn", "location");
    protected IRepositoryLocation location;
    protected IRepositoryResource resource;
    protected String relocatedTo;
    protected String locationId;
    protected int errorCode;
    protected int state = 0;

    public synchronized IRepositoryLocation getRepositoryLocation() throws HiddenException {
        if (this.state != 1) {
            this.restoreLocation();
        }
        return this.location;
    }

    public synchronized IRepositoryResource getRepositoryResource() throws HiddenException {
        if (this.state != 1) {
            this.connectToProject();
        }
        return this.resource;
    }

    public synchronized void switchResource(IRepositoryResource resource) throws CoreException {
        this.resource = SVNUtility.copyOf(resource);
        this.location = resource.getRepositoryLocation();
        SVNTeamProvider.setRepositoryLocation(this.getProject(), this.location);
    }

    public synchronized void relocateResource() throws CoreException {
        if (this.state != 1) {
            this.restoreLocation();
        }
        SVNTeamProvider.setRepositoryLocation(this.getProject(), this.location);
    }

    public static void map(IProject project, IRepositoryResource resource) throws CoreException {
        SVNTeamProvider.setRepositoryLocation(project, resource.getRepositoryLocation());
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
    }

    public String getID() {
        return "org.eclipse.team.svn.core.svnnature";
    }

    public void configureProject() {
        this.connectToProject();
        SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(new IResource[]{this.getProject()}, 0, 0));
    }

    public void deconfigure() throws CoreException {
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return new SVNTeamMoveDeleteHook();
    }

    public FileModificationValidator getFileModificationValidator2() {
        return SVNTeamPlugin.instance().getOptionProvider().getFileModificationValidator();
    }

    public boolean canHandleLinkedResources() {
        return this.canHandleLinkedResourceURI();
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public IResourceRuleFactory getRuleFactory() {
        return SVNResourceRuleFactory.INSTANCE;
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        return new SVNFileHistoryProvider();
    }

    protected void deconfigured() {
        IProject project = this.getProject();
        if (project != null) {
            try {
                project.setPersistentProperty(LOCATION_PROPERTY, null);
            }
            catch (Exception exception) {}
            try {
                project.setPersistentProperty(RESOURCE_PROPERTY, null);
            }
            catch (Exception exception) {}
        }
        SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(new IResource[]{this.getProject()}, 0, 0));
        super.deconfigured();
    }

    protected static void setRepositoryLocation(IProject project, IRepositoryLocation location) throws CoreException {
        project.setPersistentProperty(LOCATION_PROPERTY, SVNRemoteStorage.instance().repositoryLocationAsReference(location));
    }

    protected void restoreLocation() throws HiddenException {
        if (this.state == 0) {
            this.location = null;
            this.locationId = null;
            this.errorCode = this.uploadRepositoryLocation();
            if (this.errorCode == ErrorDescription.SUCCESS || (this.errorCode = this.acquireResolution(false)) == ErrorDescription.SUCCESS) {
                return;
            }
            this.performDisconnect();
        }
        this.breakThreadExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToProject() throws HiddenException {
        Class<SVNTeamProvider> clazz = SVNTeamProvider.class;
        synchronized (SVNTeamProvider.class) {
            if (this.state == 0) {
                this.location = null;
                this.locationId = null;
                this.resource = null;
                this.relocatedTo = null;
                this.errorCode = this.uploadRepositoryResource();
                if (this.errorCode == ErrorDescription.SUCCESS || (this.errorCode = this.acquireResolution(true)) == ErrorDescription.SUCCESS) {
                    this.state = 1;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.performDisconnect();
            }
            this.breakThreadExecution();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected int acquireResolution(boolean full) {
        block8: {
            block9: {
                int newError;
                while (true) {
                    Object[] context = null;
                    if (this.errorCode == ErrorDescription.REPOSITORY_LOCATION_IS_DISCARDED) {
                        context = new Object[]{this.getProject(), this.location};
                    } else if (this.errorCode == ErrorDescription.PROJECT_IS_RELOCATED_OUTSIDE_PLUGIN) {
                        context = new Object[]{this.getProject(), this.relocatedTo, this.location};
                    } else if (this.errorCode == ErrorDescription.CANNOT_READ_LOCATION_DATA) {
                        context = new Object[]{this.getProject(), this.relocatedTo, this.locationId};
                    } else if (this.errorCode == ErrorDescription.CANNOT_READ_PROJECT_METAINFORMATION) {
                        context = this.getProject();
                    }
                    if (!SVNTeamPlugin.instance().getErrorHandlingFacility().acquireResolution(new ErrorDescription(this.errorCode, context))) break block8;
                    int n = newError = full ? this.uploadRepositoryResource() : this.uploadRepositoryLocation();
                    if (newError == ErrorDescription.SUCCESS) break block9;
                    if (newError == this.errorCode) break;
                    this.errorCode = newError;
                }
                return newError;
            }
            return ErrorDescription.SUCCESS;
        }
        return this.errorCode;
    }

    protected void performDisconnect() {
        this.state = -1;
        CompositeOperation op = new CompositeOperation("Operation_OpenProject");
        op.add(new DisconnectOperation(new IProject[]{this.getProject()}, false));
        op.add(new AbstractActionOperation(op.getId()){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                throw new UnreportableException(SVNTeamProvider.this.getAutoDisconnectMessage());
            }
        });
        ProgressMonitorUtility.doTaskScheduled(op);
    }

    protected void breakThreadExecution() {
        throw new HiddenException(this.getAutoDisconnectMessage());
    }

    protected String getAutoDisconnectMessage() {
        return SVNMessages.formatErrorString("Error_AutoDisconnect", new String[]{this.getProject().getName()});
    }

    protected int uploadRepositoryResource() {
        int errorCode = this.uploadRepositoryLocation();
        IProject project = this.getProject();
        SVNChangeStatus st = SVNUtility.getSVNInfoForNotConnected((IResource)project);
        if (st != null) {
            this.relocatedTo = SVNUtility.decodeURL(st.url);
            if (this.location != null) {
                this.resource = this.location.asRepositoryContainer(this.relocatedTo, true);
                if (this.resource == null) {
                    return ErrorDescription.PROJECT_IS_RELOCATED_OUTSIDE_PLUGIN;
                }
            }
        } else {
            return ErrorDescription.CANNOT_READ_PROJECT_METAINFORMATION;
        }
        return errorCode;
    }

    protected int uploadRepositoryLocation() {
        try {
            IProject project = this.getProject();
            String data = project.getPersistentProperty(LOCATION_PROPERTY);
            if (data != null) {
                this.location = SVNRemoteStorage.instance().newRepositoryLocation(data);
                this.locationId = this.location.getId();
                if (SVNRemoteStorage.instance().getRepositoryLocation(this.location.getId()) == null) {
                    return ErrorDescription.REPOSITORY_LOCATION_IS_DISCARDED;
                }
            } else {
                data = project.getPersistentProperty(RESOURCE_PROPERTY);
                if (data != null) {
                    this.locationId = SVNTeamProvider.extractLocationId(data);
                    if (this.locationId != null) {
                        this.location = SVNRemoteStorage.instance().getRepositoryLocation(this.locationId);
                        if (this.location != null) {
                            SVNTeamProvider.setRepositoryLocation(project, this.location);
                        }
                    }
                }
            }
            return this.location == null ? ErrorDescription.CANNOT_READ_LOCATION_DATA : ErrorDescription.SUCCESS;
        }
        catch (CoreException coreException) {
            return ErrorDescription.CANNOT_READ_LOCATION_DATA;
        }
    }

    protected static String extractLocationId(String resourceData) {
        String[] data;
        if (resourceData != null && (data = resourceData.split(";")).length >= 2) {
            return data[1];
        }
        return null;
    }
}

