/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.LockOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.panel.local.LockPanel;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class LockActionHelper
extends AbstractActionHelper {
    public LockActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    public FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return super.select(info) && IStateFilter.SF_READY_TO_LOCK.accept(((AbstractSVNSyncInfo)info).getLocalResource());
            }
        };
    }

    public IActionOperation getOperation() {
        IResource[] selectedResources = this.getSyncInfoSelector().getSelectedResources();
        CommitPanel.CollectPropertiesOperation cop = new CommitPanel.CollectPropertiesOperation(selectedResources);
        ProgressMonitorUtility.doTaskExternal((IActionOperation)cop, null);
        LockPanel commentPanel = new LockPanel(true, cop.getMinLockSize());
        DefaultDialog dialog = new DefaultDialog(this.configuration.getSite().getShell(), commentPanel);
        if (dialog.open() == 0) {
            LockOperation mainOp = new LockOperation(selectedResources, commentPanel.getMessage(), commentPanel.getForce());
            CompositeOperation lockOp = new CompositeOperation(mainOp.getId());
            lockOp.add((IActionOperation)mainOp);
            lockOp.add((IActionOperation)new RefreshResourcesOperation(selectedResources));
            return lockOp;
        }
        return null;
    }
}

