/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class OpenInComparePaneAction
extends Action {
    private final ISynchronizePageConfiguration configuration;

    public OpenInComparePaneAction(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        Utils.initAction((IAction)this, (String)"action.openInCompareEditor.");
    }

    public void run() {
        IStructuredSelection strSelection;
        ISelection selection = this.configuration.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && this.isOkToRun(strSelection = (IStructuredSelection)selection)) {
            IResource resource = this.getResources(strSelection)[0];
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
            if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                remote.setSelectedRevision(SVNRevision.HEAD);
                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
            }
        }
    }

    protected boolean isOkToRun(IStructuredSelection selection) {
        IResource[] resources;
        if (selection.size() == 1 && (resources = this.getResources(selection)).length == 1) {
            IResource resource = resources[0];
            return resource.getType() == 1 && !FileUtility.checkForResourcesPresence((IResource[])new IResource[]{resource}, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY, (int)0);
        }
        return false;
    }

    protected IResource[] getResources(IStructuredSelection selection) {
        Object[] elements = selection.toArray();
        IResource[] resources = Utils.getResources((Object[])elements);
        return resources;
    }
}

