/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.variant.ResourceVariant;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNParticipant;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;

public class SynchronizeLabelDecorator
extends LabelProvider
implements ILabelDecorator {
    public static final int CONFLICTING_REPLACEMENT_MASK = 15;
    public static final int REPLACEMENT_MASK = 3;
    protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

    public Image decorateImage(Image image, Object element) {
        AbstractSVNSyncInfo info = this.getSyncInfo(element);
        if (info != null) {
            ILocalResource left = info.getLocalResource();
            ILocalResource right = ((ResourceVariant)info.getRemote()).getResource();
            OverlayedImageDescriptor imgDescr = null;
            if (IStateFilter.SF_OBSTRUCTED.accept(left)) {
                imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_OBSTRUCTED, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
            } else if ((info.getKind() & 0xF) == 15) {
                if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left) || IStateFilter.SF_PREREPLACEDREPLACED.accept(right)) {
                    imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_REPLACED_CONF, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                }
            } else if ((info.getKind() & 3) == 3) {
                if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left)) {
                    imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_REPLACED_OUT, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                } else if (IStateFilter.SF_PREREPLACEDREPLACED.accept(right)) {
                    imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_REPLACED_IN, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                }
            }
            Image tmp = this.registerImageDescriptor(imgDescr);
            if (!(left.getResource() instanceof IContainer || (left.getChangeMask() & 2) == 0 && (right.getChangeMask() & 2) == 0)) {
                if (tmp != null) {
                    image = tmp;
                }
                imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_PROPCHANGE, new Point(23, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.BOTTOM);
                return this.registerImageDescriptor(imgDescr);
            }
            return tmp;
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        ILocalResource remote;
        ResourceVariant variant;
        AbstractSVNSyncInfo info = this.getSyncInfo(element);
        if (info != null && (variant = (ResourceVariant)info.getRemote()) != null && (remote = variant.getResource()).getRevision() != -1L) {
            return String.valueOf(text) + " " + variant.getContentIdentifier();
        }
        return null;
    }

    protected Image registerImageDescriptor(OverlayedImageDescriptor imgDescr) {
        if (imgDescr != null) {
            Image img = this.images.get((Object)imgDescr);
            if (img == null) {
                img = imgDescr.createImage();
                this.images.put((ImageDescriptor)imgDescr, img);
            }
            return img;
        }
        return null;
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
    }

    protected AbstractSVNSyncInfo getSyncInfo(Object element) {
        if (element instanceof SyncInfoModelElement) {
            return (AbstractSVNSyncInfo)((SyncInfoModelElement)element).getSyncInfo();
        }
        return null;
    }
}

