/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.repository.model.IDataTreeNode;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevisions;
import org.eclipse.ui.PlatformUI;

public class RepositoryRevision
extends RepositoryFictiveNode
implements IParentTreeNode,
IDataTreeNode {
    protected static String REVISION_NAME;
    protected IRepositoryResource[] resources;
    protected RepositoryResource[] wrappers;
    protected RepositoryRevisions parent;
    protected SVNRevision revision;

    public RepositoryRevision(RepositoryRevisions parent, SVNRevision revision) {
        REVISION_NAME = SVNUIMessages.RepositoriesView_Model_Revision;
        this.parent = parent;
        this.revision = revision;
        this.refresh();
    }

    public RGB getForeground(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_FOREGROUND;
    }

    public RGB getBackground(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_BACKGROUND;
    }

    public FontData getFont(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_FONT.getFontData()[0];
    }

    public IRepositoryResource[] getRepositoryResources() {
        return this.resources;
    }

    public void refresh() {
        this.resources = this.parent.getLinks(this.revision);
        this.wrappers = RepositoryFolder.wrapChildren(null, this.resources, null);
    }

    public Object getData() {
        return null;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getLabel(Object o) {
        return BaseMessages.format((String)REVISION_NAME, (Object[])new Object[]{this.revision.toString()});
    }

    public Object[] getChildren(Object o) {
        return this.wrappers;
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RepositoryRevision) {
            RepositoryRevision other = (RepositoryRevision)obj;
            return this.parent.equals(other.parent) && this.revision.equals((Object)other.revision);
        }
        return super.equals(obj);
    }
}

