/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.CopyResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.MoveResourcesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.RemoteResourceTransfer;
import org.eclipse.team.svn.ui.RemoteResourceTransferrable;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.panel.common.CommentPanel;
import org.eclipse.team.svn.ui.repository.model.IDataTreeNode;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.IToolTipProvider;
import org.eclipse.team.svn.ui.repository.model.RepositoryBranches;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRoot;
import org.eclipse.team.svn.ui.repository.model.RepositoryTags;
import org.eclipse.team.svn.ui.repository.model.RepositoryTrunk;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTreeViewer
extends TreeViewer {
    public static final String FMT_REPOSITORY_RESOURCE = "{name}{last_change_date}{last_author}";
    public static final String FMT_REPOSITORY_FILE = "{name}{last_change_date}{last_author}{size}{lock_owner}{lock_creation_date}{lock_expiration_date}{lock_comment}";
    public static final String FMT_REPOSITORY_FOLDER = "{name}{last_change_date}{last_author}";
    public static final String FMT_REPOSITORY_BRANCHES = "{name}{last_change_date}{last_author}";
    public static final String FMT_REPOSITORY_ROOT = "{name}{last_change_date}{last_author}";
    public static final String FMT_REPOSITORY_TAGS = "{name}{last_change_date}{last_author}";
    public static final String FMT_REPOSITORY_TRUNK = "{name}{last_change_date}{last_author}";
    private static final Map<Class<?>, String> class2Format = new HashMap();
    protected List<IRefreshListener> refreshListeners = new ArrayList<IRefreshListener>();

    static {
        class2Format.put(RepositoryResource.class, "{name}{last_change_date}{last_author}");
        class2Format.put(RepositoryFile.class, FMT_REPOSITORY_FILE);
        class2Format.put(RepositoryFolder.class, "{name}{last_change_date}{last_author}");
        class2Format.put(RepositoryBranches.class, "{name}{last_change_date}{last_author}");
        class2Format.put(RepositoryRoot.class, "{name}{last_change_date}{last_author}");
        class2Format.put(RepositoryTags.class, "{name}{last_change_date}{last_author}");
        class2Format.put(RepositoryTrunk.class, "{name}{last_change_date}{last_author}");
    }

    public RepositoryTreeViewer(Composite parent) {
        super(parent);
        this.initialize();
    }

    public RepositoryTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public RepositoryTreeViewer(Tree tree) {
        super(tree);
        this.initialize();
    }

    public synchronized void addRefreshListener(IRefreshListener listener) {
        if (!this.refreshListeners.contains(listener)) {
            this.refreshListeners.add(listener);
        }
    }

    public synchronized void removeRefreshListener(IRefreshListener listener) {
        this.refreshListeners.remove(listener);
    }

    public void setExpandedState(Object element, boolean expanded) {
        TreeItem[] items = this.getIdenticalNodes(element, true);
        if (items != null && items.length > 0) {
            if (expanded) {
                this.createChildren((Widget)items[0]);
            }
            this.setExpanded((Item)items[0], expanded);
        } else {
            TreeItem[] nodes = this.getIdenticalNodes(element, false);
            if (nodes != null && nodes.length > 0) {
                super.setExpandedState(nodes[0].getData(), expanded);
            }
        }
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection tmp;
        TreeItem[] nodes;
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (nodes = this.getIdenticalNodes((tmp = (IStructuredSelection)selection).getFirstElement(), false)) != null && nodes.length > 0) {
            selection = new StructuredSelection(nodes[0].getData());
        }
        super.setSelection(selection);
    }

    public void refresh(final Object element, final IRefreshVisitor visitor, final boolean exact) {
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                TreeItem[] nodes = RepositoryTreeViewer.this.getIdenticalNodes(element, exact);
                if (nodes != null && nodes.length != 0) {
                    int i = 0;
                    while (i < nodes.length) {
                        Object data = nodes[i].getData();
                        if (visitor != null) {
                            visitor.visit(data);
                        }
                        RepositoryTreeViewer.this.internalRefresh((Widget)nodes[i], data, true, true);
                        RepositoryTreeViewer.this.fireRefresh(data);
                        ++i;
                    }
                } else {
                    Object data;
                    Object input = RepositoryTreeViewer.this.getInput();
                    if (input instanceof IDataTreeNode && (data = ((IDataTreeNode)input).getData()) != null && data.equals(element) && visitor != null) {
                        visitor.visit(input);
                    }
                    RepositoryTreeViewer.super.refresh(null);
                }
            }
        });
    }

    public void fireEmptySelectionEvent() {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)StructuredSelection.EMPTY));
    }

    protected void internalRefresh(Widget widget, Object element, boolean doStruct, boolean updateLabels) {
        if (widget instanceof Item) {
            if (doStruct) {
                this.updatePlus((Item)widget, element);
            }
            if (updateLabels || !this.equals(element, widget.getData())) {
                this.doUpdateItem(widget, element, true);
            } else {
                this.associate(element, (Item)widget);
            }
        }
        if (doStruct) {
            this.internalRefreshStruct(widget, element, updateLabels);
        } else {
            Item[] children = this.getChildren(widget);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Item item = children[i];
                    Object data = item.getData();
                    if (data != null) {
                        this.internalRefresh((Widget)item, data, doStruct, updateLabels);
                    }
                    ++i;
                }
            }
        }
    }

    protected void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        try {
            Method m = AbstractTreeViewer.class.getDeclaredMethod("updateChildren", Widget.class, Object.class, Object[].class, Boolean.TYPE);
            m.setAccessible(true);
            Object[] objectArray = new Object[4];
            objectArray[0] = widget;
            objectArray[1] = element;
            objectArray[3] = updateLabels;
            m.invoke((Object)this, objectArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Item[] children = this.getChildren(widget);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Item item = children[i];
                Object data = item.getData();
                if (data != null) {
                    this.internalRefreshStruct((Widget)item, data, updateLabels);
                }
                ++i;
            }
        }
    }

    public void refresh() {
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                RepositoryTreeViewer.super.refresh();
            }
        });
    }

    public TreeItem[] getIdenticalNodes(Object sample, boolean exact) {
        if (sample != null) {
            return this.findUnfreshNodes(this.getTree().getItems(), sample, exact);
        }
        return null;
    }

    protected synchronized void fireRefresh(Object data) {
        Object[] listeners = this.refreshListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            ((IRefreshListener)listeners[i]).refreshed(data);
            ++i;
        }
    }

    protected TreeItem[] findUnfreshNodes(TreeItem[] items, Object obj, boolean exact) {
        List<TreeItem> retVal = this.findUnfreshNodesImpl(items, obj, exact);
        return retVal == null ? null : retVal.toArray(new TreeItem[retVal.size()]);
    }

    protected List<TreeItem> findUnfreshNodes(TreeItem item, Object obj, boolean exact) {
        IDataTreeNode dataNode;
        Object data = item.getData();
        if (obj == data || !exact && obj.equals(data)) {
            return Arrays.asList(item);
        }
        if (data instanceof IDataTreeNode && (obj == (dataNode = (IDataTreeNode)data).getData() || !exact && obj.equals(dataNode.getData()))) {
            return Arrays.asList(item);
        }
        return this.findUnfreshNodesImpl(item.getItems(), obj, exact);
    }

    protected List<TreeItem> findUnfreshNodesImpl(TreeItem[] items, Object obj, boolean exact) {
        if (items != null) {
            ArrayList<TreeItem> retVal = new ArrayList<TreeItem>();
            int i = 0;
            while (i < items.length) {
                List<TreeItem> tmp = this.findUnfreshNodes(items[i], obj, exact);
                if (tmp != null) {
                    retVal.addAll(tmp);
                }
                ++i;
            }
            return retVal;
        }
        return null;
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        TreeItem[] items;
        Object node = selection.getFirstElement();
        if (node instanceof IParentTreeNode && (items = this.getIdenticalNodes(node, true)) != null && items.length > 0) {
            boolean expanded;
            boolean bl = expanded = !this.getExpanded((Item)items[0]);
            if (expanded) {
                this.createChildren((Widget)items[0]);
            }
            this.setExpanded((Item)items[0], expanded);
        }
    }

    private void initialize() {
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    RepositoryTreeViewer.this.handleDoubleClick(structured);
                }
            }
        });
        this.addDragSupport(7, new Transfer[]{RemoteResourceTransfer.getInstance()}, (DragSourceListener)new TransferDragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                if (RemoteResourceTransfer.getInstance().isSupportedType(event.dataType)) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryTreeViewer.this.getSelection();
                    ArrayList<IRepositoryResource> resources = new ArrayList<IRepositoryResource>();
                    Iterator it = selection.iterator();
                    while (it.hasNext()) {
                        resources.add(((RepositoryResource)it.next()).getRepositoryResource());
                    }
                    event.data = new RemoteResourceTransferrable(resources.toArray(new IRepositoryResource[0]), 0);
                }
            }

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RepositoryTreeViewer.this.getSelection();
                boolean canBeDragged = selection.size() > 0;
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    if (it.next() instanceof RepositoryResource) continue;
                    canBeDragged = false;
                }
                event.doit = canBeDragged;
            }

            public Transfer getTransfer() {
                return RemoteResourceTransfer.getInstance();
            }
        });
        this.addDropSupport(3, new Transfer[]{RemoteResourceTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){
            protected int expectedOperation = 2;

            public void dragOperationChanged(DropTargetEvent event) {
                this.expectedOperation = event.detail;
            }

            public void dragEnter(DropTargetEvent event) {
                this.expectedOperation = event.detail;
            }

            public void dragOver(DropTargetEvent event) {
                Tree repositoryTree = (Tree)((DropTarget)event.widget).getControl();
                TreeItem aboveItem = repositoryTree.getItem(repositoryTree.toControl(event.x, event.y));
                if (aboveItem == null) {
                    event.detail = 0;
                    return;
                }
                Object aboveObject = aboveItem.getData();
                if (!(aboveObject instanceof RepositoryResource) || aboveObject instanceof RepositoryFile) {
                    event.detail = 0;
                    return;
                }
                RepositoryResource aboveResource = (RepositoryResource)aboveObject;
                if (aboveResource.getRepositoryResource().getSelectedRevision() != SVNRevision.HEAD) {
                    event.detail = 0;
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)RepositoryTreeViewer.this.getSelection();
                int lastSlashIdx = 0;
                for (RepositoryResource current : selection) {
                    if (lastSlashIdx == 0) {
                        lastSlashIdx = current.getRepositoryResource().getUrl().lastIndexOf("/");
                    }
                    if (current.getRepositoryResource().getUrl().lastIndexOf("/") == lastSlashIdx && aboveResource != current && aboveResource != current.getParent()) continue;
                    event.detail = 0;
                    return;
                }
                event.detail = this.expectedOperation;
            }

            public void drop(DropTargetEvent event) {
                Tree repositoryTree = (Tree)((DropTarget)event.widget).getControl();
                RepositoryResource aboveResource = (RepositoryResource)repositoryTree.getItem(repositoryTree.toControl(event.x, event.y)).getData();
                CommentPanel commentPanel = new CommentPanel(event.detail == 2 ? SVNUIMessages.MoveToAction_Select_Title : SVNUIMessages.CopyToAction_Select_Title);
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), commentPanel);
                if (dialog.open() == 0) {
                    MoveResourcesOperation mainOp = event.detail == 2 ? new MoveResourcesOperation(aboveResource.getRepositoryResource(), ((RemoteResourceTransferrable)event.data).resources, commentPanel.getMessage(), null) : new CopyResourcesOperation(aboveResource.getRepositoryResource(), ((RemoteResourceTransferrable)event.data).resources, commentPanel.getMessage(), null);
                    CompositeOperation op = new CompositeOperation(mainOp.getId());
                    op.add((IActionOperation)mainOp);
                    ArrayList<IRepositoryResource> toRefresh = new ArrayList<IRepositoryResource>();
                    toRefresh.add(aboveResource.getRepositoryResource());
                    if (event.detail == 2) {
                        toRefresh.addAll((Collection)Arrays.asList(((RemoteResourceTransferrable)event.data).resources));
                    }
                    op.add((IActionOperation)new RefreshRemoteResourcesOperation(SVNUtility.getCommonParents((IRepositoryResource[])toRefresh.toArray(new IRepositoryResource[0]))), new IActionOperation[]{mainOp});
                    ProgressMonitorUtility.doTaskScheduled((IActionOperation)op);
                }
            }
        });
        this.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object data;
                String tooltipText = "";
                Tree tree = RepositoryTreeViewer.this.getTree();
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && (data = item.getData()) != null && data instanceof IToolTipProvider) {
                    tooltipText = ((IToolTipProvider)data).getToolTipMessage((String)class2Format.get(data.getClass()));
                }
                tree.setToolTipText(tooltipText);
            }

            public void mouseExit(MouseEvent e) {
                RepositoryTreeViewer.this.getTree().setToolTipText("");
            }
        });
    }

    public static interface IRefreshListener {
        public void refreshed(Object var1);
    }

    public static interface IRefreshVisitor {
        public void visit(Object var1);
    }
}

