/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.properties.ResourcePropertyEditPanel;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class ApplyPropertyMethodComposite
extends Composite {
    protected static final String PROPERTY_FILTER_HISTORY_NAME = "propertyFilter";
    protected Button applyToAllResourcesButton;
    protected Button applyToFilesButton;
    protected Button applyToFoldersButton;
    protected Button useFilterButton;
    protected Label filterLabel;
    protected Combo filterMaskText;
    protected boolean applyToFiles;
    protected boolean applyToFolders;
    protected boolean useMask;
    protected int resourcesType;
    protected String filterMask;
    protected UserInputHistory propertyFilterHistory;
    protected IValidationManager validationManager;

    public ApplyPropertyMethodComposite(Composite parent, int style, IValidationManager validationManager, int resourcesType) {
        super(parent, style);
        this.validationManager = validationManager;
        this.resourcesType = resourcesType;
        this.createControls();
    }

    public String getFilterMask() {
        return this.filterMask;
    }

    public boolean useMask() {
        return this.useMask;
    }

    public int getApplyMethod() {
        if (this.applyToFiles) {
            return 1;
        }
        if (this.applyToFolders) {
            return 2;
        }
        return 0;
    }

    public void setEnabled(boolean enabled) {
        if (this.resourcesType == ResourcePropertyEditPanel.MIXED_RESOURCES) {
            this.applyToAllResourcesButton.setEnabled(enabled);
            this.applyToFilesButton.setEnabled(enabled);
            this.applyToFoldersButton.setEnabled(enabled);
            this.useFilterButton.setEnabled(enabled);
        }
        this.filterMaskText.setEnabled(enabled && this.useFilterButton.getSelection());
        this.filterLabel.setEnabled(enabled && this.useFilterButton.getSelection());
    }

    public void saveChanges() {
        if (this.resourcesType == ResourcePropertyEditPanel.MIXED_RESOURCES) {
            this.applyToFiles = this.applyToFilesButton.getSelection();
            this.applyToFolders = this.applyToFoldersButton.getSelection();
        }
        this.filterMask = this.filterMaskText.getText();
        boolean bl = this.useMask = this.useFilterButton.getSelection() && this.useFilterButton.isEnabled();
        if (this.useMask) {
            this.propertyFilterHistory.addLine(this.filterMask);
        }
    }

    protected void createControls() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData data = null;
        Group group = new Group((Composite)this, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setText(SVNUIMessages.ApplyPropertyMethodComposite_ResourcesOptions);
        if (this.resourcesType == ResourcePropertyEditPanel.MIXED_RESOURCES) {
            this.applyToAllResourcesButton = new Button((Composite)group, 16);
            this.applyToAllResourcesButton.setLayoutData((Object)new GridData());
            this.applyToAllResourcesButton.setText(SVNUIMessages.ApplyPropertyMethodComposite_AllResources);
            this.applyToAllResourcesButton.setSelection(true);
            this.applyToFilesButton = new Button((Composite)group, 16);
            this.applyToFilesButton.setLayoutData((Object)new GridData());
            this.applyToFilesButton.setText(SVNUIMessages.ApplyPropertyMethodComposite_FilesOnly);
            this.applyToFoldersButton = new Button((Composite)group, 16);
            this.applyToFoldersButton.setLayoutData((Object)new GridData());
            this.applyToFoldersButton.setText(SVNUIMessages.ApplyPropertyMethodComposite_FoldersOnly);
        }
        Composite filter = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        filter.setLayout((Layout)layout);
        data = new GridData(768);
        filter.setLayoutData((Object)data);
        this.useFilterButton = new Button(filter, 32);
        this.useFilterButton.setText(SVNUIMessages.ApplyPropertyMethodComposite_ResourceNameFiltration);
        this.useFilterButton.setLayoutData((Object)new GridData(32));
        this.useFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ApplyPropertyMethodComposite.this.setEnabled(true);
                ApplyPropertyMethodComposite.this.validationManager.validateContent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite subFilter = new Composite(filter, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        subFilter.setLayout((Layout)layout);
        data = new GridData(768);
        subFilter.setLayoutData((Object)data);
        this.filterLabel = new Label(subFilter, 0);
        this.filterLabel.setLayoutData((Object)new GridData(32));
        this.filterLabel.setText(SVNUIMessages.ApplyPropertyMethodComposite_Mask);
        this.propertyFilterHistory = new UserInputHistory(PROPERTY_FILTER_HISTORY_NAME);
        this.filterMaskText = new Combo(subFilter, 0);
        data = new GridData(768);
        this.filterMaskText.setEnabled(this.useFilterButton.getSelection());
        this.filterMaskText.setLayoutData((Object)data);
        this.filterMaskText.setVisibleItemCount(this.propertyFilterHistory.getDepth());
        this.filterMaskText.setItems(this.propertyFilterHistory.getHistory());
        this.validationManager.attachTo((Control)this.filterMaskText, new AbstractVerifierProxy(new NonEmptyFieldVerifier(SVNUIMessages.ApplyPropertyMethodComposite_Mask_Verifier)){

            protected boolean isVerificationEnabled(Control input) {
                return ApplyPropertyMethodComposite.this.useFilterButton.getSelection() && ApplyPropertyMethodComposite.this.useFilterButton.isEnabled();
            }
        });
        this.filterMaskText.setText("*");
    }
}

