/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.eclipse.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.eclipse.team.svn.ui.panel.local.ResourceListPanel;
import org.eclipse.team.svn.ui.utility.UnacceptableOperationNotificator;

public class UpdateAction
extends AbstractRecursiveTeamAction {
    public static IStateFilter SF_MISSING_RESOURCES = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_MISSING.accept(resource, state, mask) && !IStateFilter.SF_TREE_CONFLICTING.accept(resource, state, mask);
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask);
        }
    };

    public void runImpl(IAction action) {
        IResource[] missing;
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(this.getShell(), this.getSelectedResources(IStateFilter.SF_ONREPOSITORY));
        if (resources == null || resources.length == 0) {
            return;
        }
        if (this.checkForResourcesPresenceRecursive(IStateFilter.SF_REVERTABLE) && (missing = this.getSelectedResourcesRecursive(SF_MISSING_RESOURCES)).length > 0 && !UpdateAction.updateMissing(this.getShell(), missing)) {
            return;
        }
        this.runScheduled((IActionOperation)UpdateAction.getUpdateOperation(resources));
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    public static boolean updateMissing(Shell shell, IResource[] missing) {
        ResourceListPanel panel = new ResourceListPanel(missing, SVNUIMessages.UpdateAction_List_Title, SVNUIMessages.UpdateAction_List_Description, SVNUIMessages.UpdateAction_List_Message, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
        panel.setShowLocalNames(true);
        return new DefaultDialog(shell, panel).open() == 0;
    }

    public static CompositeOperation getUpdateOperation(IResource[] updateSet) {
        UpdateOperation mainOp = new UpdateOperation(updateSet, true);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(updateSet);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp));
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((IResourceProvider)mainOp)));
        op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        return op;
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

