/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RemoveNonVersionedResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;
import org.eclipse.team.svn.core.resource.ILocalFile;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.ReplaceWarningDialog;

public class ReplaceWithLatestRevisionAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_ONREPOSITORY);
        IActionOperation op = ReplaceWithLatestRevisionAction.getReplaceOperation(resources, this.getShell());
        if (op != null) {
            this.runScheduled(op);
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    public static IActionOperation getReplaceOperation(IResource[] resources, Shell shell) {
        ReplaceWarningDialog dialog = new ReplaceWarningDialog(shell);
        if (dialog.open() == 0) {
            CompositeOperation op = new CompositeOperation("Operation_ReplaceWithLatest");
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            SaveUnversionedOperation saveUnversioned = new SaveUnversionedOperation(resources);
            op.add((IActionOperation)saveUnversioned);
            RevertOperation revertOp = new RevertOperation(resources, true);
            op.add((IActionOperation)revertOp);
            RemoveNonVersionedResourcesOperation removeOp = new RemoveNonVersionedResourcesOperation(resources, true);
            op.add((IActionOperation)removeOp, new IActionOperation[]{revertOp});
            op.add((IActionOperation)new UpdateOperation(resources, true), new IActionOperation[]{revertOp, removeOp});
            op.add((IActionOperation)new RestoreUnversionedOperation(resources, saveUnversioned));
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            return op;
        }
        return null;
    }

    protected static class RestoreUnversionedOperation
    extends AbstractWorkingCopyOperation
    implements IActionOperationProcessor {
        public SaveUnversionedOperation changes;

        public RestoreUnversionedOperation(IResource[] resources, SaveUnversionedOperation changes) {
            super("Operation_RestoreUnversioned", resources);
            this.changes = changes;
        }

        public void doOperation(IActionOperation op, IProgressMonitor monitor) {
            this.reportStatus(op.run(monitor).getStatus());
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            ResourceChange[] changes = this.changes.changes.toArray(new ResourceChange[0]);
            int i = 0;
            while (i < changes.length && !monitor.isCanceled()) {
                final ResourceChange change = changes[i];
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        change.traverse(new IResourceChangeVisitor(){

                            public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
                            }

                            public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
                                File real;
                                ILocalResource local = change.getLocal();
                                if (local instanceof ILocalFile && IStateFilter.SF_UNVERSIONED.accept(local) && !local.getResource().isDerived() && !(real = new File(FileUtility.getWorkingCopyPath((IResource)local.getResource()))).exists()) {
                                    real.getParentFile().mkdirs();
                                    if (!change.getTemporary().renameTo(real)) {
                                        FileUtility.copyFile((File)real, (File)change.getTemporary(), (IProgressMonitor)monitor);
                                        change.getTemporary().delete();
                                    }
                                }
                            }
                        }, 2, (IActionOperationProcessor)RestoreUnversionedOperation.this, monitor);
                    }
                }, monitor, changes.length);
                ++i;
            }
        }
    }

    protected static class SaveUnversionedOperation
    extends AbstractWorkingCopyOperation
    implements IActionOperationProcessor {
        public List<ResourceChange> changes = new ArrayList<ResourceChange>();

        public SaveUnversionedOperation(IResource[] resources) {
            super("Operation_SaveUnversioned", resources);
        }

        public void doOperation(IActionOperation op, IProgressMonitor monitor) {
            this.reportStatus(op.run(monitor).getStatus());
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            IResource[] resources = this.operableData();
            int i = 0;
            while (i < resources.length && !monitor.isCanceled()) {
                final IResource current = resources[i];
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(current);
                        ResourceChange change = ResourceChange.wrapLocalResource(null, (ILocalResource)local, (boolean)true);
                        change.traverse(new IResourceChangeVisitor(){

                            public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
                                File real;
                                ILocalResource local = change.getLocal();
                                if (local instanceof ILocalFile && IStateFilter.SF_UNVERSIONED.accept(local) && !local.getResource().isDerived() && (real = new File(FileUtility.getWorkingCopyPath((IResource)local.getResource()))).exists() && !real.renameTo(change.getTemporary())) {
                                    FileUtility.copyFile((File)change.getTemporary(), (File)real, (IProgressMonitor)monitor);
                                    real.delete();
                                }
                            }

                            public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
                            }
                        }, 2, (IActionOperationProcessor)SaveUnversionedOperation.this, monitor);
                        SaveUnversionedOperation.this.changes.add(change);
                    }
                }, monitor, resources.length);
                ++i;
            }
        }
    }
}

