/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.utility;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.Team;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNDiffStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNMergeStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.options.IIgnoreRecommendations;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.SSHSettings;
import org.eclipse.team.svn.core.resource.SSLSettings;
import org.eclipse.team.svn.core.svnstorage.SVNCachedProxyCredentialsManager;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.Notify2Composite;
import org.eclipse.team.svn.core.utility.PatternProvider;
import org.eclipse.team.svn.core.utility.RepositoryLocationUtility;
import org.eclipse.team.svn.core.utility.SVNURLStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SVNUtility {
    private static String svnFolderName = null;

    public static IRepositoryResource asRepositoryResource(String url, boolean isFolder) {
        if (!SVNUtility.isValidSVNURL(url)) {
            return null;
        }
        IRepositoryRoot[] roots = SVNUtility.findRoots(url, true);
        IRepositoryResource retVal = null;
        if (roots.length > 0) {
            retVal = isFolder ? roots[0].asRepositoryContainer(url, false) : roots[0].asRepositoryFile(url, false);
        } else {
            IRepositoryLocation location = SVNRemoteStorage.instance().newRepositoryLocation();
            SVNUtility.initializeRepositoryLocation(location, url);
            retVal = isFolder ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
        }
        return retVal;
    }

    public static void initializeRepositoryLocation(IRepositoryLocation location, String url) {
        location.setStructureEnabled(true);
        location.setTrunkLocation(CoreExtensionsManager.instance().getOptionProvider().getDefaultTrunkName());
        location.setBranchesLocation(CoreExtensionsManager.instance().getOptionProvider().getDefaultBranchesName());
        location.setTagsLocation(CoreExtensionsManager.instance().getOptionProvider().getDefaultTagsName());
        Path urlPath = new Path(url);
        if (urlPath.lastSegment().equals(location.getTrunkLocation())) {
            url = urlPath.removeLastSegments(1).toString();
        }
        location.setUrl(url);
    }

    public static IRepositoryResource getCopiedFrom(IResource resource) {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if (local.isCopied()) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
            ISVNConnector proxy = location.acquireSVNProxy();
            final SVNChangeStatus[] st = new SVNChangeStatus[1];
            try {
                try {
                    final String path = FileUtility.getWorkingCopyPath(resource);
                    proxy.status(path, 0, 129L, null, new ISVNEntryStatusCallback(){

                        public void next(SVNChangeStatus status) {
                            if (path.equals(status.path)) {
                                st[0] = status;
                            }
                        }
                    }, new SVNNullProgressMonitor());
                }
                catch (SVNConnectorException sVNConnectorException) {
                    location.releaseSVNProxy(proxy);
                    return null;
                }
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
            if (st[0] != null) {
                String url = st[0].urlCopiedFrom;
                if (url == null) {
                    IRepositoryResource tmp;
                    IContainer parent = resource.getParent();
                    if (parent != null && parent.getType() != 8 && (tmp = SVNUtility.getCopiedFrom((IResource)parent)) != null) {
                        url = String.valueOf(tmp.getUrl()) + "/" + resource.getName();
                    }
                } else {
                    url = SVNUtility.decodeURL(url);
                }
                IRepositoryResource retVal = SVNRemoteStorage.instance().asRepositoryResource(location, url, resource.getType() == 1);
                retVal.setSelectedRevision(SVNRevision.fromNumber(st[0].revisionCopiedFrom == -1L ? st[0].revision : st[0].revisionCopiedFrom));
                return retVal;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Map<String, SVNEntryRevisionReference> parseSVNExternalsProperty(String property, IRepositoryResource propertyHolder) {
        if (property == null) {
            return Collections.emptyMap();
        }
        retVal = new HashMap<String, SVNEntryRevisionReference>();
        externals = property.trim().split("[\\n|\\r\\n]+");
        i = 0;
        while (i < externals.length) {
            parts = externals[i].trim().split("[\\t ]+");
            if (parts.length < 2 || parts.length > 4) {
                throw new UnreportableException("Malformed external, " + parts.length + ", " + externals[i]);
            }
            name = null;
            url = null;
            revision = null;
            pegRevision = null;
            if (SVNUtility.isValidSVNURL(parts[parts.length - 1])) {
                name = parts[0];
                try {
                    url = parts[1];
                    if (parts.length == 4) {
                        revision = SVNRevision.fromString(parts[2]);
                        url = parts[3];
                    }
                    if (parts.length != 3) ** GOTO lbl74
                    revision = SVNRevision.fromString(parts[1].substring(2));
                    url = parts[2];
                }
                catch (Exception v0) {
                    throw new UnreportableException("Malformed external, " + parts.length + ", " + externals[i]);
                }
            } else {
                block28: {
                    name = parts[parts.length - 1];
                    try {
                        url = parts[0];
                        if (parts.length == 4) {
                            revision = SVNRevision.fromString(parts[1]);
                            url = parts[2];
                        } else if (parts.length == 3) {
                            revision = SVNRevision.fromString(parts[0].substring(2));
                            url = parts[1];
                        }
                    }
                    catch (Exception v1) {
                        throw new UnreportableException("Malformed external, " + parts.length + ", " + externals[i]);
                    }
                    if (!SVNUtility.isValidSVNURL(url)) {
                        if (url.startsWith("^/")) {
                            url = String.valueOf(propertyHolder.getRepositoryLocation().getRepositoryRoot().getUrl()) + url.substring(1);
                        } else if (url.startsWith("//")) {
                            try {
                                protocol = SVNUtility.getSVNUrl(propertyHolder.getUrl()).getProtocol();
                                if (propertyHolder.getUrl().indexOf(":///") != -1) {
                                    url = String.valueOf(protocol) + ":/" + url;
                                    break block28;
                                }
                                url = String.valueOf(protocol) + ":" + url;
                            }
                            catch (MalformedURLException v2) {}
                        } else if (url.startsWith("/")) {
                            prefix = propertyHolder.getUrl();
                            idx = prefix.lastIndexOf("//");
                            idx = prefix.indexOf(47, idx + 2);
                            url = String.valueOf(prefix.substring(0, idx)) + url;
                        } else if (url.startsWith("../")) {
                            prefix = propertyHolder;
                            while (url.startsWith("../")) {
                                url = url.substring(3);
                                if ((prefix = prefix.getParent()) != null) continue;
                                throw new UnreportableException("Malformed external, " + parts.length + ", " + externals[i]);
                            }
                            url = String.valueOf(prefix.getUrl()) + "/" + url;
                        } else {
                            throw new UnreportableException("Malformed external, " + parts.length + ", " + externals[i]);
                        }
                    }
                }
                ref = SVNUtility.asEntryReference(url);
                url = ref.path;
                pegRevision = ref.pegRevision;
            }
lbl74:
            // 4 sources

            try {
                url = SVNUtility.decodeURL(url);
            }
            catch (IllegalArgumentException v3) {}
            url = SVNUtility.normalizeURL(url);
            retVal.put(name, new SVNEntryRevisionReference(url, pegRevision, revision));
            ++i;
        }
        return retVal;
    }

    public static SVNEntryReference asEntryReference(String url) {
        if (url == null) {
            return null;
        }
        int idx = url.lastIndexOf(64);
        SVNRevision peg = null;
        if (idx != -1) {
            try {
                peg = SVNRevision.fromString(url.substring(idx + 1));
                url = url.substring(0, idx);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return new SVNEntryReference(url, peg);
    }

    public static boolean useSingleReferenceSignature(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2) {
        int kind1 = reference1.revision.getKind();
        int kind2 = reference2.revision.getKind();
        if (!(kind1 != 5 && kind1 != 6 || kind2 != 5 && kind2 != 6)) {
            return false;
        }
        return reference1.path.equals(reference2.path) && (reference1.pegRevision == reference2.pegRevision || reference1.pegRevision != null && reference1.pegRevision.equals(reference2.pegRevision));
    }

    public static SVNEntryRevisionReference getEntryRevisionReference(IRepositoryResource resource) {
        return new SVNEntryRevisionReference(SVNUtility.encodeURL(resource.getUrl()), resource.getPegRevision(), resource.getSelectedRevision());
    }

    public static SVNEntryReference getEntryReference(IRepositoryResource resource) {
        return new SVNEntryReference(SVNUtility.encodeURL(resource.getUrl()), resource.getPegRevision());
    }

    public static SVNProperty[] properties(ISVNConnector proxy, SVNEntryRevisionReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final SVNProperty[][] retVal = new SVNProperty[1][];
        proxy.getProperties(reference, 0, null, new ISVNPropertyCallback(){

            public void next(String path, SVNProperty[] data) {
                retVal[0] = data;
            }
        }, monitor);
        return retVal[0];
    }

    public static SVNChangeStatus[] status(ISVNConnector proxy, String path, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList statuses = new ArrayList();
        proxy.status(path, depth, options, null, new ISVNEntryStatusCallback(){

            public void next(SVNChangeStatus status) {
                statuses.add(status);
            }
        }, monitor);
        return statuses.toArray(new SVNChangeStatus[statuses.size()]);
    }

    public static void diffStatus(ISVNConnector proxy, final Collection<SVNDiffStatus> statuses, SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        proxy.diffStatus(reference1, reference2, depth, options, null, new ISVNDiffStatusCallback(){

            public void next(SVNDiffStatus status) {
                statuses.add(status);
            }
        }, monitor);
    }

    public static void diffStatus(ISVNConnector proxy, final Collection<SVNDiffStatus> statuses, SVNEntryReference reference, SVNRevision revision1, SVNRevision revision2, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        proxy.diffStatus(reference, revision1, revision2, depth, options, null, new ISVNDiffStatusCallback(){

            public void next(SVNDiffStatus status) {
                statuses.add(status);
            }
        }, monitor);
    }

    public static SVNMergeStatus[] mergeStatus(ISVNConnector proxy, SVNEntryReference reference, SVNRevisionRange[] revisions, String path, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList statuses = new ArrayList();
        proxy.mergeStatus(reference, revisions, path, depth, options, new ISVNMergeStatusCallback(){

            public void next(SVNMergeStatus status) {
                statuses.add(status);
            }
        }, monitor);
        return statuses.toArray(new SVNMergeStatus[statuses.size()]);
    }

    public static SVNEntry[] list(ISVNConnector proxy, SVNEntryRevisionReference reference, int depth, int direntFields, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList entries = new ArrayList();
        proxy.list(reference, depth, direntFields, options, new ISVNEntryCallback(){

            public void next(SVNEntry entry) {
                entries.add(entry);
            }
        }, monitor);
        return entries.toArray(new SVNEntry[entries.size()]);
    }

    public static SVNLogEntry[] logEntries(ISVNConnector proxy, SVNEntryReference reference, SVNRevision revisionStart, SVNRevision revisionEnd, long options, String[] revProps, long limit, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList entries = new ArrayList();
        proxy.logEntries(reference, revisionStart, revisionEnd, revProps, limit, options, new ISVNLogEntryCallback(){
            private Stack<SVNLogEntry> mergeTreeBuilder = new Stack();

            public void next(SVNLogEntry log) {
                if (log.revision == -1L) {
                    log = this.mergeTreeBuilder.pop();
                    if (this.mergeTreeBuilder.isEmpty()) {
                        entries.add(log);
                    }
                    return;
                }
                if (!this.mergeTreeBuilder.isEmpty()) {
                    this.mergeTreeBuilder.peek().add(log);
                } else if (!log.hasChildren()) {
                    entries.add(log);
                }
                if (log.hasChildren()) {
                    this.mergeTreeBuilder.push(log);
                }
            }
        }, monitor);
        return entries.toArray(new SVNLogEntry[entries.size()]);
    }

    public static SVNEntryInfo[] info(ISVNConnector proxy, SVNEntryRevisionReference reference, int depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList infos = new ArrayList();
        proxy.info(reference, depth, null, new ISVNEntryInfoCallback(){

            public void next(SVNEntryInfo info) {
                infos.add(info);
            }
        }, monitor);
        return infos.toArray(new SVNEntryInfo[infos.size()]);
    }

    public static String getStatusText(String status) {
        if (status == null) {
            status = "NotExists";
        }
        return SVNTeamPlugin.instance().getResource("Status." + status);
    }

    public static String getOldRoot(String oldUrl, IRepositoryResource[] rootChildren) {
        int i = 0;
        while (i < rootChildren.length) {
            String childName = rootChildren[i].getName();
            int idx = oldUrl.indexOf(childName);
            if (idx > 0 && oldUrl.charAt(idx - 1) == '/' && (oldUrl.endsWith(childName) || oldUrl.charAt(idx + childName.length()) == '/')) {
                return oldUrl.substring(0, idx - 1);
            }
            ++i;
        }
        return null;
    }

    public static IRepositoryRoot getTrunkLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getTrunkLocation());
    }

    public static IRepositoryRoot getBranchesLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getBranchesLocation());
    }

    public static IRepositoryRoot getTagsLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getTagsLocation());
    }

    public static IRepositoryContainer getProposedTrunk(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedTrunkLocation(location), false);
    }

    public static IRepositoryContainer getProposedBranches(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedBranchesLocation(location), false);
    }

    public static IRepositoryContainer getProposedTags(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedTagsLocation(location), false);
    }

    public static String getProposedTrunkLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? String.valueOf(baseUrl) + "/" + location.getTrunkLocation() : baseUrl;
    }

    public static String getProposedBranchesLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? String.valueOf(baseUrl) + "/" + location.getBranchesLocation() : baseUrl;
    }

    public static String getProposedTagsLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? String.valueOf(baseUrl) + "/" + location.getTagsLocation() : baseUrl;
    }

    public static IRepositoryRoot[] findRoots(String resourceUrl, boolean longestOnly) {
        if (!SVNUtility.isValidSVNURL(resourceUrl)) {
            return new IRepositoryRoot[0];
        }
        Path url = new Path(resourceUrl);
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        ArrayList<IRepositoryRoot> roots = new ArrayList<IRepositoryRoot>();
        int i = 0;
        while (i < locations.length) {
            Path locationUrl = new Path(locations[i].getUrl());
            if ((url.segmentCount() >= locationUrl.segmentCount() || url.isPrefixOf((IPath)locationUrl)) && (locationUrl.isPrefixOf((IPath)url) || new Path(locations[i].getRepositoryRootUrl()).isPrefixOf((IPath)url))) {
                SVNUtility.addRepositoryRoot(roots, (IRepositoryRoot)locations[i].asRepositoryContainer(resourceUrl, false).getRoot(), longestOnly);
            }
            ++i;
        }
        IRepositoryRoot[] repositoryRoots = roots.toArray(new IRepositoryRoot[roots.size()]);
        if (!longestOnly) {
            Arrays.sort(repositoryRoots, new Comparator<IRepositoryRoot>(){

                @Override
                public int compare(IRepositoryRoot first, IRepositoryRoot second) {
                    return second.getUrl().compareTo(first.getUrl());
                }
            });
        }
        return repositoryRoots;
    }

    private static void addRepositoryRoot(List<IRepositoryRoot> container, IRepositoryRoot root, boolean longestOnly) {
        if (longestOnly && container.size() > 0) {
            int cnt2;
            int cnt = new Path(root.getUrl()).segmentCount();
            if (cnt > (cnt2 = new Path(container.get(0).getUrl()).segmentCount())) {
                container.clear();
                container.add(root);
            } else if (cnt == cnt2) {
                container.add(root);
            }
        } else {
            container.add(root);
        }
    }

    public static synchronized String getSVNFolderName() {
        if (svnFolderName == null) {
            String name = FileUtility.getEnvironmentVariables().get("SVN_ASP_DOT_NET_HACK") != null ? "_svn" : ".svn";
            svnFolderName = System.getProperty("javasvn.admindir", name);
        }
        return svnFolderName;
    }

    public static String getResourceParent(IRepositoryResource resource) {
        String rootUrl;
        String parent = "";
        String url = resource.getUrl();
        if (url.equals(rootUrl = resource.getRoot().getUrl())) {
            return "";
        }
        parent = url.substring(rootUrl.length(), url.length() - resource.getName().length() - 1);
        return parent;
    }

    public static IRepositoryResource copyOf(IRepositoryResource resource) {
        String url = resource.getUrl();
        return resource instanceof IRepositoryFile ? resource.asRepositoryFile(url, false) : resource.asRepositoryContainer(url, false);
    }

    public static IRepositoryResource[] makeResourceSet(IRepositoryResource upPoint, String relativeReference, boolean isFile) {
        String url = SVNUtility.normalizeURL(String.valueOf(upPoint.getUrl()) + "/" + relativeReference);
        IRepositoryLocation location = upPoint.getRepositoryLocation();
        IRepositoryResource downPoint = isFile ? location.asRepositoryFile(url, false) : location.asRepositoryContainer(url, false);
        downPoint.setPegRevision(upPoint.getPegRevision());
        downPoint.setSelectedRevision(upPoint.getSelectedRevision());
        return SVNUtility.makeResourceSet(upPoint, downPoint);
    }

    public static IRepositoryResource[] makeResourceSet(IRepositoryResource upPoint, IRepositoryResource downPoint) {
        ArrayList<IRepositoryResource> resourceSet = new ArrayList<IRepositoryResource>();
        while (downPoint != null && !downPoint.equals(upPoint)) {
            resourceSet.add(0, downPoint);
            downPoint = downPoint.getParent();
        }
        return resourceSet.toArray(new IRepositoryResource[resourceSet.size()]);
    }

    public static boolean isValidSVNURL(String url) {
        try {
            URL svnUrl = SVNUtility.getSVNUrl(url);
            String host = svnUrl.getHost();
            return (host.matches("[a-zA-Z0-9_\\-]+(?:\\.[a-zA-Z0-9_\\-]+)*") || host.length() <= 0) && (host.length() != 0 || "file".equals(svnUrl.getProtocol()));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static URL getSVNUrl(String url) throws MalformedURLException {
        return SVNUtility.getSVNUrlStreamHandler(url).getURL();
    }

    public static SVNURLStreamHandler getSVNUrlStreamHandler(String url) throws MalformedURLException {
        SVNURLStreamHandler retVal = new SVNURLStreamHandler();
        new URL(null, url, retVal);
        return retVal;
    }

    public static String base64Encode(String data) {
        if (data == null) {
            return null;
        }
        return new String(Base64.encode((byte[])data.getBytes()));
    }

    public static String base64Decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        return new String(Base64.decode((byte[])encoded.getBytes()));
    }

    public static synchronized void addSVNNotifyListener(ISVNConnector proxy, ISVNNotificationCallback listener) {
        Notify2Composite composite = (Notify2Composite)proxy.getNotificationCallback();
        if (composite == null) {
            composite = new Notify2Composite();
            proxy.setNotificationCallback(composite);
        }
        composite.add(listener);
    }

    public static synchronized void removeSVNNotifyListener(ISVNConnector proxy, ISVNNotificationCallback listener) {
        Notify2Composite composite = (Notify2Composite)proxy.getNotificationCallback();
        if (composite != null) {
            composite.remove(listener);
        }
    }

    public static void reorder(SVNDiffStatus[] statuses, final boolean parent2Child) {
        Arrays.sort(statuses, new Comparator<SVNDiffStatus>(){

            @Override
            public int compare(SVNDiffStatus d1, SVNDiffStatus d2) {
                return parent2Child ? d1.pathPrev.compareTo(d2.pathPrev) : d2.pathPrev.compareTo(d1.pathPrev);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    public static void reorder(SVNChangeStatus[] statuses, final boolean parent2Child) {
        Arrays.sort(statuses, new Comparator<SVNChangeStatus>(){

            @Override
            public int compare(SVNChangeStatus o1, SVNChangeStatus o2) {
                String s1 = o1.path;
                String s2 = o2.path;
                return parent2Child ? s1.compareTo(s2) : s2.compareTo(s1);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    public static void reorder(IRepositoryResource[] resources, final boolean parent2Child) {
        Arrays.sort(resources, new Comparator<IRepositoryResource>(){

            @Override
            public int compare(IRepositoryResource o1, IRepositoryResource o2) {
                String s1 = o1.getUrl();
                String s2 = o2.getUrl();
                return parent2Child ? s1.compareTo(s2) : s2.compareTo(s1);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    public static String encodeURL(String url) {
        try {
            url = SVNUtility.normalizeURL(url);
            int idx = url.startsWith("file:///") ? "file:///".length() : (url.startsWith("file://") ? url.indexOf("/", "file://".length()) + 1 : url.indexOf("://") + 3);
            idx = url.indexOf("/", idx);
            if (idx == -1) {
                return url;
            }
            String retVal = url.substring(0, idx);
            StringTokenizer tok = new StringTokenizer(url.substring(idx), "/ ", true);
            idx = retVal.indexOf(64);
            if (idx != -1) {
                String protocol = retVal.substring(0, retVal.indexOf("://") + 3);
                String serverPart = retVal.substring(idx);
                retVal = String.valueOf(protocol) + retVal.substring(protocol.length(), idx) + serverPart;
            }
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                retVal = token.equals("/") ? String.valueOf(retVal) + token : (token.equals(" ") ? String.valueOf(retVal) + "%20" : String.valueOf(retVal) + URLEncoder.encode(token, "UTF-8"));
            }
            return retVal;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decodeURL(String url) {
        try {
            url = SVNUtility.normalizeURL(url);
            int idx = url.startsWith("file:///") ? "file:///".length() : (url.startsWith("file://") ? url.indexOf("/", "file://".length()) + 1 : url.indexOf("://") + 3);
            idx = url.indexOf("/", idx);
            if (idx == -1) {
                return url;
            }
            String retVal = url.substring(0, idx);
            StringTokenizer tok = new StringTokenizer(url.substring(idx), "/+", true);
            idx = retVal.indexOf(64);
            if (idx != -1) {
                String protocol = retVal.substring(0, retVal.indexOf("://") + 3);
                String serverPart = retVal.substring(idx);
                retVal = String.valueOf(protocol) + retVal.substring(protocol.length(), idx) + serverPart;
            }
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                retVal = token.equals("/") || token.equals("+") ? String.valueOf(retVal) + token : String.valueOf(retVal) + URLDecoder.decode(token, "UTF-8");
            }
            return retVal;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String normalizeURL(String url) {
        StringTokenizer tokenizer = new StringTokenizer(PatternProvider.replaceAll(url, "([\\\\])+", "/"), "/", false);
        String retVal = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            retVal = String.valueOf(retVal) + (retVal.length() == 0 ? token : "/" + token);
        }
        int idx = retVal.indexOf(58) + 1;
        return idx == 0 ? retVal : String.valueOf(retVal.substring(0, idx)) + (url.startsWith("file:///") ? "//" : "/") + retVal.substring(idx);
    }

    public static Exception validateRepositoryLocation(IRepositoryLocation location) {
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            try {
                proxy.list(new SVNEntryRevisionReference(SVNUtility.encodeURL(location.getUrl()), null, null), 0, 0, 0L, new ISVNEntryCallback(){

                    public void next(SVNEntry entry) {
                    }
                }, new SVNNullProgressMonitor());
            }
            catch (Exception e) {
                Exception exception = e;
                location.releaseSVNProxy(proxy);
                location.dispose();
                return exception;
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
            location.dispose();
        }
        return null;
    }

    public static void configureProxy(ISVNConnector proxy, IRepositoryLocation location) {
        proxy.setUsername(location.getUsername());
        proxy.setPassword(location.getPassword());
        SSLSettings sslSettings = location.getSSLSettings();
        String host = "localhost";
        String protocol = "file";
        try {
            protocol = SVNUtility.getSVNUrl(location.getUrl()).getProtocol();
            if (!protocol.equals("file")) {
                host = SVNUtility.getSVNUrl(location.getUrl()).getHost();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        IProxyService proxyService = SVNTeamPlugin.instance().getProxyService();
        String proxyType = protocol.equals("https") ? "HTTPS" : "HTTP";
        SVNCachedProxyCredentialsManager proxyCredetialsManager = SVNRemoteStorage.instance().getProxyCredentialsManager();
        IProxyData proxyData = proxyService.getProxyDataForHost(host, proxyType);
        if (proxyService.isProxiesEnabled() && proxyData != null) {
            proxy.setProxy(proxyData.getHost(), proxyData.getPort(), proxyCredetialsManager.getUsername(), proxyCredetialsManager.getPassword());
        } else {
            proxy.setProxy(null, -1, null, null);
        }
        if (sslSettings.isAuthenticationEnabled()) {
            proxy.setClientSSLCertificate(sslSettings.getCertificatePath(), sslSettings.getPassPhrase());
        } else {
            proxy.setClientSSLCertificate(null, null);
        }
        SSHSettings sshSettings = location.getSSHSettings();
        if (!sshSettings.isUseKeyFile()) {
            proxy.setSSHCredentials(location.getUsername(), location.getPassword(), sshSettings.getPort());
        } else if (sshSettings.getPrivateKeyPath().length() > 0) {
            proxy.setSSHCredentials(location.getUsername(), sshSettings.getPrivateKeyPath(), sshSettings.getPassPhrase(), sshSettings.getPort());
        } else {
            proxy.setSSHCredentials(null, null, null, -1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SVNChangeStatus getSVNInfoForNotConnected(IResource root) {
        IPath checkedPath;
        IPath location = FileUtility.getResourcePath(root);
        IPath iPath = checkedPath = root.getType() == 1 ? location.removeLastSegments(1) : location;
        if (!checkedPath.append(SVNUtility.getSVNFolderName()).toFile().exists()) {
            return null;
        }
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        try {
            SVNChangeStatus[] st = SVNUtility.status(proxy, location.toString(), 2, 128L, new SVNNullProgressMonitor());
            if (st != null && st.length > 0) {
                SVNUtility.reorder(st, true);
                SVNChangeStatus sVNChangeStatus = st[0].url == null ? null : st[0];
                return sVNChangeStatus;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            proxy.dispose();
        }
    }

    public static String getPropertyForNotConnected(IResource root, String propertyName) {
        String location = FileUtility.getWorkingCopyPath(root);
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        try {
            SVNProperty data = proxy.getProperty(new SVNEntryRevisionReference(location, null, SVNRevision.WORKING), propertyName, new SVNNullProgressMonitor());
            String string = data == null ? null : data.value;
            return string;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            proxy.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIgnored(IResource resource) {
        if (resource instanceof IWorkspaceRoot) return true;
        if (resource.isDerived()) return true;
        if (FileUtility.isSVNInternals(resource)) return true;
        if (Team.isIgnoredHint((IResource)resource)) return true;
        if (SVNUtility.isMergeParts(resource)) {
            return true;
        }
        try {
            IIgnoreRecommendations[] ignores = CoreExtensionsManager.instance().getIgnoreRecommendations();
            int i = 0;
            while (true) {
                if (i >= ignores.length) {
                    return false;
                }
                if (ignores[i].isAcceptableNature(resource) && ignores[i].isIgnoreRecommended(resource)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static Map<IProject, List<IResource>> splitWorkingCopies(IResource[] resources) {
        HashMap<IProject, List<IResource>> wc2Resources = new HashMap<IProject, List<IResource>>();
        int i = 0;
        while (i < resources.length) {
            IProject wcRoot = resources[i].getProject();
            ArrayList<IResource> wcResources = (ArrayList<IResource>)wc2Resources.get(wcRoot);
            if (wcResources == null) {
                wcResources = new ArrayList<IResource>();
                wc2Resources.put(wcRoot, wcResources);
            }
            wcResources.add(resources[i]);
            ++i;
        }
        return wc2Resources;
    }

    public static Map splitWorkingCopies(File[] files) {
        HashMap wc2Resources = new HashMap();
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        try {
            HashMap<File, SVNEntryInfo> file2info = new HashMap<File, SVNEntryInfo>();
            int i = 0;
            while (i < files.length) {
                file2info.put(files[i], SVNUtility.getSVNInfo(files[i], proxy));
                ++i;
            }
            ArrayList restOfFiles = new ArrayList(Arrays.asList(files));
            while (restOfFiles.size() > 0) {
                SVNEntryInfo info;
                File current = (File)restOfFiles.get(0);
                Object[] wcRoot = SVNUtility.getWCRoot(proxy, current, info = (SVNEntryInfo)file2info.get(current));
                ArrayList<File> wcResources = (ArrayList<File>)wc2Resources.get(wcRoot[0]);
                if (wcResources == null) {
                    wcResources = new ArrayList<File>();
                    wc2Resources.put(wcRoot[0], wcResources);
                }
                Path rootPath = new Path(((File)wcRoot[0]).getAbsolutePath());
                Path rootInfoPath = new Path(((SVNEntryInfo)wcRoot[1]).url);
                Iterator it = restOfFiles.iterator();
                while (it.hasNext()) {
                    File checked = (File)it.next();
                    if (!rootPath.isPrefixOf((IPath)new Path(checked.getAbsolutePath())) || !rootInfoPath.isPrefixOf((IPath)new Path(((SVNEntryInfo)file2info.get((Object)checked)).url))) continue;
                    wcResources.add(checked);
                    it.remove();
                }
            }
        }
        finally {
            proxy.dispose();
        }
        return wc2Resources;
    }

    private static Object[] getWCRoot(ISVNConnector proxy, File node, SVNEntryInfo info) {
        File oldRoot = node;
        SVNEntryInfo oldInfo = info;
        node = node.getParentFile();
        while (node != null) {
            SVNEntryInfo rootInfo = SVNUtility.getSVNInfo(node, proxy);
            if (rootInfo != null) {
                if (oldInfo == null) {
                    oldInfo = rootInfo;
                } else if (!new Path(rootInfo.url).isPrefixOf((IPath)new Path(oldInfo.url))) {
                    return new Object[]{oldRoot, oldInfo};
                }
                oldRoot = node;
                node = node.getParentFile();
                continue;
            }
            if (oldInfo == null) continue;
            return new Object[]{oldRoot, oldInfo};
        }
        if (oldInfo == null) {
            String errMessage = SVNTeamPlugin.instance().getResource("Error.NonSVNPath", new String[]{oldRoot.getAbsolutePath()});
            throw new RuntimeException(errMessage);
        }
        return new Object[]{oldRoot, oldInfo};
    }

    public static SVNEntryInfo getSVNInfo(File root) {
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        try {
            SVNEntryInfo sVNEntryInfo = SVNUtility.getSVNInfo(root, proxy);
            return sVNEntryInfo;
        }
        finally {
            proxy.dispose();
        }
    }

    public static SVNEntryInfo getSVNInfo(File root, ISVNConnector proxy) {
        if (root.exists()) {
            File svnMeta = root.isDirectory() ? root : root.getParentFile();
            if ((svnMeta = new File(String.valueOf(svnMeta.getAbsolutePath()) + "/" + SVNUtility.getSVNFolderName())).exists()) {
                try {
                    SVNEntryInfo[] st = SVNUtility.info(proxy, new SVNEntryRevisionReference(root.getAbsolutePath(), null, SVNRevision.BASE), 0, new SVNNullProgressMonitor());
                    return st != null && st.length != 0 ? st[0] : null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public static String[] asURLArray(IRepositoryResource[] resources, boolean encode) {
        String[] retVal = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            retVal[i] = encode ? SVNUtility.encodeURL(resources[i].getUrl()) : resources[i].getUrl();
            ++i;
        }
        return retVal;
    }

    public static Map splitRepositoryLocations(IRepositoryResource[] resources) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<IRepositoryResource>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<IRepositoryResource>>();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            ArrayList<IRepositoryResource> tResources = (ArrayList<IRepositoryResource>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<IRepositoryResource>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(resources[i]);
            ++i;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static Map splitRepositoryLocations(IResource[] resources) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<IResource>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<IResource>>();
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = storage.getRepositoryLocation(resources[i]);
            ArrayList<IResource> tResources = (ArrayList<IResource>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<IResource>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(resources[i]);
            ++i;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static Map splitRepositoryLocations(File[] files) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<File>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<File>>();
        int i = 0;
        while (i < files.length) {
            IRepositoryResource resource = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = resource.getRepositoryLocation();
            ArrayList<File> tResources = (ArrayList<File>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<File>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(files[i]);
            ++i;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static int getNodeKind(String path, int kind, boolean ignoreNone) {
        File f = new File(path);
        if (f.exists()) {
            return f.isDirectory() ? 2 : 1;
        }
        if (kind == 2) {
            return 2;
        }
        if (kind == 1) {
            return 1;
        }
        if (ignoreNone) {
            return 0;
        }
        String errMessage = SVNTeamPlugin.instance().getResource("Error.UnrecognizedNodeKind", new String[]{String.valueOf(kind), path});
        throw new RuntimeException(errMessage);
    }

    public static IRepositoryResource[] shrinkChildNodes(IRepositoryResource[] resources) {
        HashSet<IRepositoryResource> roots = new HashSet<IRepositoryResource>((Collection)Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            if (SVNUtility.hasRoots(roots, resources[i])) {
                roots.remove(resources[i]);
            }
            ++i;
        }
        return roots.toArray(new IRepositoryResource[roots.size()]);
    }

    public static IRepositoryResource[] getCommonParents(IRepositoryResource[] resources) {
        HashMap<IRepositoryResource, ArrayList<IRepositoryResource>> byRepositoryRoots = new HashMap<IRepositoryResource, ArrayList<IRepositoryResource>>();
        int i = 0;
        while (i < resources.length) {
            IRepositoryResource root = resources[i].getRoot();
            ArrayList<IRepositoryResource> tmp = (ArrayList<IRepositoryResource>)byRepositoryRoots.get(root);
            if (tmp == null) {
                tmp = new ArrayList<IRepositoryResource>();
                byRepositoryRoots.put(root, tmp);
            }
            tmp.add(resources[i]);
            ++i;
        }
        HashSet<IRepositoryResource> container = new HashSet<IRepositoryResource>();
        for (ArrayList tmp : byRepositoryRoots.values()) {
            IRepositoryResource parent = SVNUtility.getCommonParent(tmp.toArray(new IRepositoryResource[tmp.size()]));
            if (parent == null) continue;
            container.add(parent);
        }
        return container.toArray(new IRepositoryResource[container.size()]);
    }

    public static String getAscendant(IRepositoryResource resource) {
        String pathUpToRoot = SVNUtility.getPathUpToRoot(resource);
        int idx = pathUpToRoot.indexOf(47);
        return idx == -1 ? pathUpToRoot : pathUpToRoot.substring(0, idx);
    }

    public static String getDescendant(IRepositoryResource resource) {
        String pathUpToRoot = SVNUtility.getPathUpToRoot(resource);
        int idx = pathUpToRoot.lastIndexOf(47);
        return idx == -1 ? pathUpToRoot : pathUpToRoot.substring(idx + 1);
    }

    public static String getPathUpToRoot(IRepositoryResource resource) {
        IRepositoryResource root = resource.getRoot();
        return root == resource ? resource.getName() : resource.getUrl().substring(root.getUrl().length() + 1);
    }

    public static int compareRevisions(SVNRevision first, SVNRevision second, SVNEntryRevisionReference referenceFirst, SVNEntryRevisionReference referenceSecond, ISVNConnector proxy) throws SVNConnectorException {
        SVNEntryInfo[] entryInfo;
        if (first.getKind() == 1 && second.getKind() == 1) {
            SVNRevision.Number fromNumber = (SVNRevision.Number)first;
            SVNRevision.Number toNumber = (SVNRevision.Number)second;
            return fromNumber.getNumber() > toNumber.getNumber() ? 1 : (fromNumber.getNumber() == toNumber.getNumber() ? 0 : -1);
        }
        SVNRevision.Date fromDate = null;
        SVNRevision.Date toDate = null;
        if (first.getKind() == 2) {
            fromDate = (SVNRevision.Date)first;
        } else {
            entryInfo = SVNUtility.info(proxy, referenceFirst, -2, new SVNNullProgressMonitor());
            fromDate = SVNRevision.fromDate(entryInfo[0].lastChangedDate);
        }
        if (second.getKind() == 2) {
            toDate = (SVNRevision.Date)second;
        } else {
            entryInfo = SVNUtility.info(proxy, referenceSecond, -2, new SVNNullProgressMonitor());
            toDate = SVNRevision.fromDate(entryInfo[0].lastChangedDate);
        }
        return fromDate.getDate() > toDate.getDate() ? 1 : (fromDate.getDate() == toDate.getDate() ? 0 : -1);
    }

    private static boolean isMergeParts(IResource resource) {
        String ext = resource.getFileExtension();
        return ext != null && ext.matches("r(\\d)+");
    }

    private static Map combineLocationsByUUID(Map repository2Resources) throws Exception {
        HashMap locationUtility2Resources = new HashMap();
        for (Map.Entry entry : repository2Resources.entrySet()) {
            IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
            List tResources = (List)entry.getValue();
            RepositoryLocationUtility locationUtility = new RepositoryLocationUtility(location);
            ArrayList tResources2 = (ArrayList)locationUtility2Resources.get(locationUtility);
            if (tResources2 == null) {
                tResources2 = new ArrayList();
                locationUtility2Resources.put(locationUtility, tResources2);
            }
            tResources2.addAll(tResources);
        }
        repository2Resources.clear();
        for (Map.Entry entry : locationUtility2Resources.entrySet()) {
            RepositoryLocationUtility locationUtility = (RepositoryLocationUtility)entry.getKey();
            repository2Resources.put(locationUtility.location, entry.getValue());
        }
        return repository2Resources;
    }

    private static boolean hasRoots(Set<IRepositoryResource> roots, IRepositoryResource node) {
        while ((node = node.getParent()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static IRepositoryResource getCommonParent(IRepositoryResource[] resources) {
        if (resources == null || resources.length == 0) {
            return null;
        }
        IRepositoryResource base = resources[0].getParent();
        while (base != null) {
            int startsCnt = 0;
            Path baseUrl = new Path(base.getUrl());
            int i = 0;
            while (i < resources.length) {
                if (baseUrl.isPrefixOf((IPath)new Path(resources[i].getUrl()))) {
                    ++startsCnt;
                }
                ++i;
            }
            if (startsCnt == resources.length) break;
            base = base.getParent();
        }
        return base;
    }

    private static IRepositoryRoot getRootLocation(IRepositoryResource resource, String rootName) {
        IRepositoryLocation location = resource.getRepositoryLocation();
        IRepositoryRoot root = (IRepositoryRoot)resource.getRoot();
        if (!location.isStructureEnabled()) {
            return root;
        }
        int rootKind = root.getKind();
        if (rootKind == 4) {
            return (IRepositoryRoot)root.asRepositoryContainer(rootName, false);
        }
        if (rootKind == 0) {
            IRepositoryResource parent = root.getParent();
            if (parent == null) {
                return (IRepositoryRoot)root.asRepositoryContainer(rootName, false);
            }
            IRepositoryRoot tmp = (IRepositoryRoot)parent.getRoot();
            rootKind = tmp.getKind();
            if (rootKind == 4) {
                return (IRepositoryRoot)root.asRepositoryContainer(rootName, false);
            }
            root = tmp;
        }
        IRepositoryResource rootParent = root.getParent();
        return (IRepositoryRoot)rootParent.asRepositoryContainer(rootName, false);
    }

    public static boolean isTagOperated(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (((IRepositoryRoot)SVNRemoteStorage.instance().asRepositoryResource(resources[i]).getRoot()).getKind() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getDepthArg(int depth) {
        String depthArg = " --depth ";
        if (depth == 0) {
            return String.valueOf(depthArg) + "empty ";
        }
        if (depth == 3) {
            return String.valueOf(depthArg) + "infinity";
        }
        if (depth == 2) {
            return String.valueOf(depthArg) + "immediates ";
        }
        return String.valueOf(depthArg) + "files ";
    }

    private SVNUtility() {
    }
}

