/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocateProjectsOperation
extends AbstractRepositoryOperation
implements IRepositoryResourceProvider {
    public static final int LEVEL_ALL = -1;
    protected IRepositoryResource[] foundProjects;
    protected ILocateFilter filter;
    protected int levelLimitation;

    public LocateProjectsOperation(IRepositoryResource[] startFrom, ILocateFilter filter) {
        this(startFrom, filter, -1);
    }

    public LocateProjectsOperation(IRepositoryResource[] startFrom, ILocateFilter filter, int limitation) {
        super("Operation.LocateProjects", startFrom);
        this.levelLimitation = limitation;
        this.filter = filter;
    }

    @Override
    public IRepositoryResource[] getRepositoryResources() {
        return this.foundProjects;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] baseFolders = SVNUtility.shrinkChildNodes(this.operableData());
        int i = 0;
        while (i < baseFolders.length) {
            baseFolders[i] = baseFolders[i].getRepositoryLocation().asRepositoryContainer(baseFolders[i].getUrl(), false);
            ++i;
        }
        ArrayList<IRepositoryResource> found = new ArrayList<IRepositoryResource>();
        this.findProjects(monitor, found, baseFolders, 0);
        this.foundProjects = found.toArray(new IRepositoryResource[found.size()]);
    }

    protected void findProjects(IProgressMonitor monitor, final List<IRepositoryResource> found, IRepositoryResource[] baseFolders, final int level) throws Exception {
        int i = 0;
        while (i < baseFolders.length && !monitor.isCanceled()) {
            final IRepositoryResource current = baseFolders[i];
            if (this.isCheckEnabled(level, current)) {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        if (current instanceof IRepositoryContainer) {
                            String message = LocateProjectsOperation.this.getOperationResource("Scanning");
                            ProgressMonitorUtility.setTaskInfo(monitor, LocateProjectsOperation.this, MessageFormat.format(message, current.getUrl()));
                            IRepositoryResource[] children = ((IRepositoryContainer)current).getChildren();
                            if (LocateProjectsOperation.this.filter.isProject(current, children)) {
                                found.add(current);
                            } else if (LocateProjectsOperation.this.isRecursionEnabled(level)) {
                                LocateProjectsOperation.this.findProjects(monitor, found, children, level + 1);
                            }
                        }
                    }
                }, monitor, baseFolders.length);
            }
            ++i;
        }
    }

    protected boolean isCheckEnabled(int level, IRepositoryResource current) {
        IRepositoryLocation location;
        return level <= 0 || !(location = current.getRepositoryLocation()).isStructureEnabled() || !current.getName().equals(location.getBranchesLocation()) && !current.getName().equals(location.getTagsLocation());
    }

    protected boolean isRecursionEnabled(int level) {
        return this.levelLimitation <= -1 || level < this.levelLimitation;
    }

    public static interface ILocateFilter {
        public boolean isProject(IRepositoryResource var1, IRepositoryResource[] var2);
    }
}

