/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CreatePatchOperation
extends AbstractRepositoryOperation {
    protected String fileName;
    protected boolean recurse;
    protected boolean ignoreDeleted;
    protected boolean processBinary;
    protected boolean ignoreAncestry;

    public CreatePatchOperation(IRepositoryResource first, IRepositoryResource second, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary) {
        this(first, second, fileName, recurse, ignoreDeleted, processBinary, true);
    }

    public CreatePatchOperation(IRepositoryResource first, IRepositoryResource second, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean ignoreAncestry) {
        super("Operation.CreatePatchRemote", new IRepositoryResource[]{first, second});
        this.fileName = fileName;
        this.recurse = recurse;
        this.ignoreDeleted = ignoreDeleted;
        this.processBinary = processBinary;
        this.ignoreAncestry = ignoreAncestry;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource first = this.operableData()[0];
        IRepositoryResource second = this.operableData()[1];
        IRepositoryLocation location = first.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNEntryRevisionReference ref1 = SVNUtility.getEntryRevisionReference(first);
            SVNEntryRevisionReference ref2 = SVNUtility.getEntryRevisionReference(second);
            long options = this.ignoreAncestry ? 512L : 0L;
            options |= this.ignoreDeleted ? 8192L : 0L;
            options |= this.processBinary ? 4L : 0L;
            if (SVNUtility.useSingleReferenceSignature(ref1, ref2)) {
                this.writeToConsole(0, "svn diff -r " + ref1.revision + ":" + ref2.revision + " \"" + first.getUrl() + "@" + ref1.pegRevision + "\"" + (this.recurse ? "" : " -N") + (this.ignoreDeleted ? " --no-diff-deleted" : "") + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.diff(ref1, ref1.revision, ref2.revision, null, this.fileName, this.recurse ? 3 : 2, options, null, new SVNProgressMonitor(this, monitor, null));
            } else {
                this.writeToConsole(0, "svn diff \"" + first.getUrl() + "@" + first.getSelectedRevision() + "\" \"" + second.getUrl() + "@" + second.getSelectedRevision() + "\"" + (this.recurse ? "" : " -N") + (this.ignoreDeleted ? " --no-diff-deleted" : "") + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.diff(ref1, ref2, null, this.fileName, this.recurse ? 3 : 2, options, null, new SVNProgressMonitor(this, monitor, null));
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

