/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class BreakLockOperation
extends AbstractRepositoryOperation {
    public BreakLockOperation(IRepositoryResource[] resources) {
        super("Operation.BreakLock", resources);
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        Map splittedSet = SVNUtility.splitRepositoryLocations(resources);
        for (Map.Entry entry : splittedSet.entrySet()) {
            final IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
            List values = (List)entry.getValue();
            final String[] paths = SVNUtility.asURLArray(values.toArray(new IRepositoryResource[values.size()]), true);
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    BreakLockOperation.this.writeToConsole(0, "svn unlock");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        BreakLockOperation.this.writeToConsole(0, " \"" + SVNUtility.decodeURL(paths[i]) + "\"");
                        ++i;
                    }
                    BreakLockOperation.this.writeToConsole(0, " --force" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.unlock(paths, 4L, new SVNProgressMonitor(BreakLockOperation.this, monitor, null));
                }
            }, monitor, splittedSet.size());
            location.releaseSVNProxy(proxy);
        }
    }
}

