/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RefreshResourcesOperation
extends AbstractWorkingCopyOperation {
    public static int REFRESH_CACHE = 0;
    public static int REFRESH_CHANGES = 1;
    public static int REFRESH_ALL = 2;
    protected int depth;
    protected int refreshType;

    public RefreshResourcesOperation(IResource[] resources) {
        this(resources, 2, REFRESH_CHANGES);
    }

    public RefreshResourcesOperation(IResource[] resources, int depth, int refreshType) {
        super("Operation.RefreshResources", resources);
        this.depth = depth;
        this.refreshType = refreshType;
    }

    public RefreshResourcesOperation(IResourceProvider provider) {
        this(provider, 2, REFRESH_CHANGES);
    }

    public RefreshResourcesOperation(IResourceProvider provider, int depth, int refreshType) {
        super("Operation.RefreshResources", provider);
        this.depth = depth;
        this.refreshType = refreshType;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = super.getSchedulingRule();
        if (rule instanceof IWorkspaceRoot) {
            return rule;
        }
        IResource[] resources = this.operableData();
        HashSet<ISchedulingRule> ruleSet = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            ruleSet.add(SVNResourceRuleFactory.INSTANCE.refreshRule(resources[i]));
            ++i;
        }
        return new MultiRule((ISchedulingRule[])ruleSet.toArray(new IResource[ruleSet.size()]));
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources;
        IResource[] original = resources = this.operableData();
        if (this.depth == 2) {
            resources = FileUtility.shrinkChildNodes(resources);
        }
        if (this.refreshType != REFRESH_CACHE) {
            int i = 0;
            while (i < resources.length && !monitor.isCanceled()) {
                ProgressMonitorUtility.setTaskInfo(monitor, this, resources[i].getName());
                final IResource resource = resources[i];
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        if (resource instanceof IContainer && RefreshResourcesOperation.this.depth != 2) {
                            RefreshResourcesOperation.this.refreshMetaInfo((IContainer)resource);
                        }
                        if (!(resource instanceof IProject)) {
                            IContainer parent = resource.getParent();
                            RefreshResourcesOperation.this.refreshMetaInfo(parent);
                        }
                        RefreshResourcesOperation.this.doRefresh(resource, RefreshResourcesOperation.this.depth);
                    }
                }, monitor, resources.length);
                ++i;
            }
        }
        if (this.refreshType != REFRESH_CHANGES) {
            SVNRemoteStorage.instance().refreshLocalResources(resources, this.depth);
            IResource[] roots = FileUtility.getPathNodes(resources);
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(roots, 0, 1));
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(original, this.depth, 0));
        }
    }

    protected void refreshMetaInfo(IContainer container) throws Exception {
        IResource metaInfo = container.findMember(SVNUtility.getSVNFolderName());
        if (metaInfo != null) {
            this.doRefresh(metaInfo, 2);
        }
    }

    protected void doRefresh(final IResource resource, final int depth) throws Exception {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                resource.refreshLocal(depth, monitor);
                FileUtility.findAndMarkSVNInternals(resource, true);
            }
        }, null, 1, (IProgressMonitor)new NullProgressMonitor());
    }
}

