/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class LockOperation
extends AbstractWorkingCopyOperation {
    protected String message;
    protected boolean force;

    public LockOperation(IResource[] resources, String message, boolean force) {
        super("Operation.Lock", resources);
        this.message = message;
        this.force = force;
    }

    public LockOperation(IResourceProvider provider, String message, boolean force) {
        super("Operation.Lock", provider);
        this.message = message;
        this.force = force;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        Map<IProject, List<IResource>> wc2Resources = SVNUtility.splitWorkingCopies(resources);
        Iterator<Map.Entry<IProject, List<IResource>>> it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry<IProject, List<IResource>> entry = it.next();
            final IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation((IResource)entry.getKey());
            final String[] paths = FileUtility.asPathArray(entry.getValue().toArray(new IResource[0]));
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    LockOperation.this.writeToConsole(0, "svn lock");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        LockOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    LockOperation.this.writeToConsole(0, String.valueOf(LockOperation.this.force ? " --force" : "") + " -m \"" + LockOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.lock(paths, LockOperation.this.message, LockOperation.this.force ? 4L : 0L, new SVNProgressMonitor(LockOperation.this, monitor, null));
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
    }
}

