/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.property;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;

public class RemovePropertyOperation
extends AbstractFileOperation {
    protected boolean isRecursive;
    protected String[] names;

    public RemovePropertyOperation(File[] files, String[] names, boolean isRecursive) {
        super("Operation.RemovePropertiesFile", files);
        this.names = names;
        this.isRecursive = isRecursive;
    }

    public RemovePropertyOperation(IFileProvider provider, String[] names, boolean isRecursive) {
        super("Operation.RemovePropertiesFile", provider);
        this.names = names;
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.isRecursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < RemovePropertyOperation.this.names.length && !monitor.isCanceled()) {
                        final String name = RemovePropertyOperation.this.names[i];
                        RemovePropertyOperation.this.protectStep(new IUnprotectedOperation(){

                            public void run(IProgressMonitor monitor) throws Exception {
                                proxy.removeProperty(current.getAbsolutePath(), name, (this).RemovePropertyOperation.this.isRecursive ? 3 : 0, null, new SVNProgressMonitor(RemovePropertyOperation.this, monitor, null));
                            }
                        }, monitor, RemovePropertyOperation.this.names.length);
                        ++i;
                    }
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected ISchedulingRule getSchedulingRule(File file) {
        return file.isDirectory() ? new AbstractFileOperation.LockingRule(file) : super.getSchedulingRule(file);
    }
}

