/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.utility.FileUtility;

public class AddToSVNOperation
extends AbstractFileOperation {
    protected boolean isRecursive;

    public AddToSVNOperation(File[] files, boolean isRecursive) {
        super("Operation.AddToSVNFile", files);
        this.isRecursive = isRecursive;
    }

    public AddToSVNOperation(IFileProvider provider, boolean isRecursive) {
        super("Operation.AddToSVNFile", provider);
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.isRecursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        } else {
            FileUtility.reorder(files, true);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryLocation location = SVNFileStorage.instance().asRepositoryResource(current, false).getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    AddToSVNOperation.this.writeToConsole(0, "svn add \"" + FileUtility.normalizePath(current.getAbsolutePath()) + "\"" + (AddToSVNOperation.this.isRecursive ? "" : " -N") + "\n");
                    File parent = current.getParentFile();
                    if (parent != null) {
                        org.eclipse.team.svn.core.operation.local.AddToSVNOperation.removeFromParentIgnore(proxy, parent.getAbsolutePath(), current.getName());
                    }
                    proxy.add(current.getAbsolutePath(), ISVNConnector.Depth.infinityOrEmpty(AddToSVNOperation.this.isRecursive), 12L, new SVNProgressMonitor(AddToSVNOperation.this, monitor, null));
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

