/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.history;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.history.ResourceContentStorage;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

public class SVNRemoteResourceRevision
extends FileRevision {
    protected SVNLogEntry msg;
    protected IRepositoryResource remote;
    protected boolean isDeletionRev;

    public SVNRemoteResourceRevision(IRepositoryResource remote, SVNLogEntry msg) {
        this.remote = remote;
        this.msg = msg;
        if (this.msg.changedPaths != null) {
            int i = 0;
            while (i < this.msg.changedPaths.length && !this.isDeletionRev) {
                if (this.msg.changedPaths[i].action == 'D' && this.remote.getUrl().endsWith(this.msg.changedPaths[i].path)) {
                    this.isDeletionRev = true;
                }
                ++i;
            }
        }
    }

    public URI getURI() {
        try {
            return new URI(this.remote.getUrl());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public long getTimestamp() {
        return this.msg.date == 0L ? -1L : this.msg.date;
    }

    public boolean exists() {
        return !this.isDeletionRev;
    }

    public String getContentIdentifier() {
        return String.valueOf(this.msg.revision);
    }

    public String getAuthor() {
        return this.msg.author;
    }

    public String getComment() {
        return this.msg.message;
    }

    public String getName() {
        return this.remote.getName();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        ResourceContentStorage retVal = new ResourceContentStorage(this.remote);
        retVal.fetchContents(monitor);
        return retVal;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return this;
    }
}

