/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class ResourceChangeListener
implements IResourceChangeListener,
ISaveParticipant {
    public static int INTERESTING_CHANGES = 323584;

    public void resourceChanged(final IResourceChangeEvent event) {
        ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation("Operation.ResourcesChanged"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                final HashSet modified = new HashSet();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 8) {
                            return true;
                        }
                        if (!FileUtility.isConnected(resource)) {
                            return false;
                        }
                        if (FileUtility.isSVNInternals(resource)) {
                            IContainer parent = resource.getParent();
                            modified.add(parent);
                            if (parent.exists()) {
                                modified.addAll((Collection)Arrays.asList(parent.members()));
                            }
                            return false;
                        }
                        if (delta.getKind() == 1 || delta.getKind() == 2) {
                            modified.add(resource);
                        }
                        if (delta.getKind() == 4) {
                            int flags = delta.getFlags();
                            if (resource instanceof IContainer && (flags & INTERESTING_CHANGES) != 0 || resource instanceof IFile && (flags & (INTERESTING_CHANGES | 0x100)) != 0) {
                                modified.add(resource);
                            }
                        }
                        return true;
                    }
                }, 2);
                IResource[] resources = modified.toArray(new IResource[modified.size()]);
                SVNRemoteStorage.instance().refreshLocalResources(resources, 2);
                SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(FileUtility.getPathNodes(resources), 0, 1));
                SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(resources, 0, 0));
            }
        });
    }

    public void handleInitialWorkspaceDelta() throws CoreException {
        ISavedState ss = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)SVNTeamPlugin.instance(), (ISaveParticipant)this);
        if (ss != null) {
            ss.processResourceChangeEvents((IResourceChangeListener)this);
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }
}

