/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.mylyn;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.utility.StringId;
import org.eclipse.team.svn.mylyn.SVNMylynIntegrationPlugin;
import org.eclipse.team.svn.ui.debugmail.ReportPartsFactory;
import org.eclipse.team.svn.ui.extension.factory.IReporter;
import org.eclipse.team.svn.ui.extension.factory.IReporterFactory;
import org.eclipse.team.svn.ui.extension.factory.IReportingDescriptor;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class MylynReporter
extends AbstractActionOperation
implements IReporter {
    protected TaskRepository repository;
    protected AbstractTaskDataHandler taskDataHandler;
    protected IReportingDescriptor settings;
    protected IReporterFactory.ReportType type;
    protected IStatus problemStatus;
    protected String summary;
    protected String reportId;
    protected String userComment;

    public MylynReporter(TaskRepository repository, AbstractTaskDataHandler taskDataHandler, IReportingDescriptor settings, IReporterFactory.ReportType type) {
        super(SVNMylynIntegrationPlugin.instance().getResource("Operation.OpenReportEditor"));
        this.settings = settings;
        this.type = type;
        this.repository = repository;
        this.taskDataHandler = taskDataHandler;
        this.reportId = StringId.generateRandom((String)"ID", (int)5);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        String kind = this.repository.getConnectorKind();
        TaskAttributeMapper attributeFactory = this.taskDataHandler.getAttributeMapper(this.repository);
        final TaskData taskData = new TaskData(attributeFactory, kind, this.repository.getRepositoryUrl(), "");
        boolean isInitializedSuccessfully = this.taskDataHandler.initializeTaskData(this.repository, taskData, (ITaskMapping)new TaskMapping(){

            public String getSummary() {
                return MylynReporter.this.buildSubject();
            }

            public String getTaskKind() {
                return MylynReporter.this.type == IReporterFactory.ReportType.BUG ? "normal" : "enhancement";
            }

            public String getDescription() {
                return MylynReporter.this.buildReport();
            }

            public String getProduct() {
                return MylynReporter.this.settings.getProductName();
            }
        }, monitor);
        if (!isInitializedSuccessfully) {
            throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.team.svn.mylyn", 1, "The selected repository does not support creating new tasks."));
        }
        taskData.getRoot().getMappedAttribute("task.common.summary").setValue(this.buildSubject());
        taskData.getRoot().getMappedAttribute("task.common.description").setValue(this.buildReport());
        taskData.getRoot().getAttribute(BugzillaAttribute.BUG_SEVERITY.getKey()).setValue(this.type == IReporterFactory.ReportType.BUG ? "normal" : "enhancement");
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    TasksUiInternal.createAndOpenNewTask((TaskData)taskData);
                }
                catch (CoreException e) {
                    MylynReporter.this.reportError(e);
                }
            }
        });
    }

    public String buildReport() {
        String report = ReportPartsFactory.getVersionPart((IReportingDescriptor)this.settings);
        if (this.userComment != null) {
            report = String.valueOf(report) + ReportPartsFactory.getUserCommentPart((String)this.userComment);
        }
        report = String.valueOf(report) + ReportPartsFactory.getSVNClientPart();
        if (this.type == IReporterFactory.ReportType.BUG) {
            report = String.valueOf(report) + ReportPartsFactory.getJVMPropertiesPart();
            if (this.problemStatus != null) {
                report = String.valueOf(report) + ReportPartsFactory.getStatusPart((IStatus)this.problemStatus);
            }
        }
        if (!this.settings.isTrackerSupportsHTML()) {
            report = ReportPartsFactory.removeHTMLTags((String)report);
        }
        return report;
    }

    public String buildSubject() {
        String subject = "[" + this.settings.getProductName() + "] - ";
        subject = String.valueOf(subject) + (this.summary != null ? this.summary : String.valueOf(this.type == IReporterFactory.ReportType.BUG ? "Bug report " : "Tip for improvement ") + this.reportId);
        return subject;
    }

    public IReportingDescriptor getReportingDescriptor() {
        return this.settings;
    }

    public boolean isCustomEditorSupported() {
        return true;
    }

    public void setProblemStatus(IStatus problemStatus) {
        this.problemStatus = problemStatus;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setUserComment(String userComment) {
        this.userComment = userComment;
    }

    public void setUserEMail(String userEMail) {
    }

    public void setUserName(String userName) {
    }
}

