/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;

public class UserInputHistory {
    protected static final String HISTORY_NAME_BASE = "history.";
    protected String name;
    protected int depth;
    protected List history;

    public UserInputHistory(String name) {
        this(name, 5);
    }

    public UserInputHistory(String name, int depth) {
        this.name = name;
        this.depth = depth;
        this.loadHistoryLines();
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    public String[] getHistory() {
        return this.history.toArray(new String[this.history.size()]);
    }

    public void addLine(String line) {
        if (line == null || line.trim().length() == 0) {
            return;
        }
        this.history.remove(line);
        this.history.add(0, line);
        if (this.history.size() > this.depth) {
            this.history.remove(this.history.size() - 1);
        }
        this.saveHistoryLines();
    }

    public void clear() {
        this.history.clear();
        this.saveHistoryLines();
    }

    protected void loadHistoryLines() {
        this.history = new ArrayList();
        String historyData = SVNTeamUIPlugin.instance().getPreferenceStore().getString(HISTORY_NAME_BASE + this.name);
        if (historyData != null && historyData.length() > 0) {
            String[] historyArray = historyData.split(";");
            int i = 0;
            while (i < historyArray.length) {
                historyArray[i] = new String(Base64.decode((byte[])historyArray[i].getBytes()));
                ++i;
            }
            this.history.addAll((Collection)Arrays.asList(historyArray));
        }
    }

    protected void saveHistoryLines() {
        String result = "";
        for (String str : this.history) {
            str = new String(Base64.encode((byte[])str.getBytes()));
            result = String.valueOf(result) + (result.length() == 0 ? str : ";" + str);
        }
        SVNTeamUIPlugin.instance().getPreferenceStore().setValue(HISTORY_NAME_BASE + this.name, result);
    }
}

