/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.variant;

import java.text.MessageFormat;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.ui.synchronize.variant.ResourceVariant;

public abstract class RemoteResourceVariant
extends ResourceVariant {
    protected static String svnAuthor;

    public RemoteResourceVariant(ILocalResource local) {
        super(local);
        svnAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.Author");
    }

    protected String getCacheId() {
        return "Remote: " + super.getCacheId();
    }

    public String getContentIdentifier() {
        if (IStateFilter.SF_PREREPLACED.accept(this.local)) {
            return "";
        }
        String retVal = super.getContentIdentifier();
        if ((!this.isNotOnRepository() || this.local.isCopied()) && this.local.getAuthor() != null) {
            retVal = String.valueOf(retVal) + " " + MessageFormat.format(svnAuthor, this.local.getAuthor());
        }
        return retVal;
    }
}

