/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.action.IResourceSelector;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.svn.ui.synchronize.variant.ResourceVariant;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

public abstract class AbstractSynchronizeModelAction
extends SynchronizeModelAction {
    protected IResourceSelector syncInfoSelector;
    protected IResourceSelector treeNodeSelector;

    public AbstractSynchronizeModelAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.setEnabled(false);
        this.setToolTipText(text);
        this.createSyncInfoSelector();
        this.createTreeNodeSelector();
    }

    public AbstractSynchronizeModelAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
        this.setEnabled(false);
        this.setToolTipText(text);
        this.createSyncInfoSelector();
        this.createTreeNodeSelector();
    }

    protected final SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IActionOperation op = this.getOperation(configuration, elements);
        return new FilteredSynchronizeModelOperation(configuration, elements, op);
    }

    protected abstract IActionOperation getOperation(ISynchronizePageConfiguration var1, IDiffElement[] var2);

    protected void createSyncInfoSelector() {
        this.syncInfoSelector = new IResourceSelector(){

            public IResource[] getSelectedResources() {
                return this.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(IStateFilter.SF_ALL, false));
            }

            public IResource[] getSelectedResources(IStateFilter filter) {
                if (filter instanceof ISyncStateFilter) {
                    return this.getSelectedResources((ISyncStateFilter)filter);
                }
                return this.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(filter, false));
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                return this.getSelectedResources(filter);
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                return this.getSelectedResources(filter);
            }

            private IResource[] getSelectedResources(ISyncStateFilter filter) {
                AbstractSVNSyncInfo[] infos = AbstractSynchronizeModelAction.this.getSVNSyncInfos();
                HashSet<Object> retVal = new HashSet<Object>();
                int i = 0;
                while (i < infos.length) {
                    ILocalResource local = infos[i].getLocalResource();
                    ILocalResource remote = ((ResourceVariant)infos[i].getRemote()).getResource();
                    if (remote instanceof IResourceChange && filter.acceptRemote(remote.getResource(), remote.getStatus(), remote.getChangeMask()) || filter.accept(local)) {
                        retVal.add(local.getResource());
                    }
                    ++i;
                }
                if (filter.acceptGroupNodes()) {
                    HashSet selection = new HashSet(Arrays.asList(AbstractSynchronizeModelAction.this.getSelectedElements()));
                    IDiffElement[] iDiffElementArray = AbstractSynchronizeModelAction.this.getFilteredDiffElements();
                    int n = iDiffElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDiffElement element = iDiffElementArray[n2];
                        if (element instanceof ISynchronizeModelElement && retVal.contains(((ISynchronizeModelElement)element).getResource())) {
                            IDiffContainer parent = element.getParent();
                            ArrayList<IResource> parents = new ArrayList<IResource>();
                            while (parent != null && parent instanceof ISynchronizeModelElement && ((ISynchronizeModelElement)parent).getResource() != null) {
                                parents.add(((ISynchronizeModelElement)parent).getResource());
                                if (selection.contains(parent)) {
                                    retVal.addAll(parents);
                                    break;
                                }
                                parent = parent.getParent();
                            }
                        }
                        ++n2;
                    }
                }
                return retVal.toArray(new IResource[retVal.size()]);
            }
        };
    }

    protected void createTreeNodeSelector() {
        this.treeNodeSelector = new IResourceSelector(){

            @Override
            public IResource[] getSelectedResources() {
                return this.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(IStateFilter.SF_ALL, true));
            }

            @Override
            public IResource[] getSelectedResources(IStateFilter filter) {
                return this.getSelectedResourcesRecursive(filter, 0);
            }

            @Override
            public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                return this.getSelectedResourcesRecursive(filter, 2);
            }

            @Override
            public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                if (filter instanceof ISyncStateFilter) {
                    return this.getSelectedResourcesRecursive((ISyncStateFilter)filter, depth);
                }
                return this.getSelectedResourcesRecursive(new ISyncStateFilter.StateFilterWrapper(filter, true), depth);
            }

            private IResource[] getSelectedResourcesRecursive(ISyncStateFilter filter, int depth) {
                HashSet<IResource> retVal = new HashSet<IResource>();
                ISynchronizeModelElement[] iSynchronizeModelElementArray = AbstractSynchronizeModelAction.this.getSelectedElements();
                int n = iSynchronizeModelElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISynchronizeModelElement element = iSynchronizeModelElementArray[n2];
                    this.fetchSelectedNodes(retVal, element, filter, depth);
                    ++n2;
                }
                return retVal.toArray(new IResource[retVal.size()]);
            }

            private void fetchSelectedNodes(Set<IResource> nodes, ISynchronizeModelElement node, ISyncStateFilter filter, int depth) {
                ILocalResource change;
                IResource resource = node.getResource();
                if (filter.accept(SVNRemoteStorage.instance().asLocalResource(resource))) {
                    nodes.add(resource);
                } else if (node instanceof SyncInfoModelElement && (change = ((ResourceVariant)((AbstractSVNSyncInfo)((SyncInfoModelElement)node).getSyncInfo()).getRemote()).getResource()) instanceof IResourceChange && filter.acceptRemote(change.getResource(), change.getStatus(), change.getChangeMask())) {
                    nodes.add(resource);
                }
                if (depth != 0) {
                    int sizeBefore = nodes.size();
                    IDiffElement[] iDiffElementArray = node.getChildren();
                    int n = iDiffElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDiffElement element = iDiffElementArray[n2];
                        this.fetchSelectedNodes(nodes, (ISynchronizeModelElement)element, filter, depth == 2 ? 2 : 0);
                        ++n2;
                    }
                    if (sizeBefore != nodes.size() && filter.acceptGroupNodes()) {
                        nodes.add(resource);
                    }
                }
            }
        };
    }

    protected IResource getSelectedResource() {
        ISynchronizeModelElement[] selection = this.getSelectedElements();
        return selection.length == 0 ? null : this.getSelectedElements()[0].getResource();
    }

    protected AbstractSVNSyncInfo getSelectedSVNSyncInfo() {
        ISynchronizeModelElement[] selection = this.getSelectedElements();
        if (selection.length == 0 || !(selection[0] instanceof SyncInfoModelElement)) {
            return null;
        }
        return (AbstractSVNSyncInfo)((SyncInfoModelElement)selection[0]).getSyncInfo();
    }

    protected AbstractSVNSyncInfo[] getSVNSyncInfos() {
        ArrayList<AbstractSVNSyncInfo> filtered = new ArrayList<AbstractSVNSyncInfo>();
        IDiffElement[] iDiffElementArray = this.getFilteredDiffElements();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement e = iDiffElementArray[n2];
            filtered.add((AbstractSVNSyncInfo)((SyncInfoModelElement)e).getSyncInfo());
            ++n2;
        }
        return filtered.toArray(new AbstractSVNSyncInfo[filtered.size()]);
    }

    protected ISynchronizeModelElement[] getSelectedElements() {
        ArrayList<ISynchronizeModelElement> retVal = new ArrayList<ISynchronizeModelElement>();
        IStructuredSelection selection = this.getStructuredSelection();
        for (Object element : selection) {
            if (!(element instanceof ISynchronizeModelElement)) continue;
            retVal.add((ISynchronizeModelElement)element);
        }
        return retVal.toArray(new ISynchronizeModelElement[retVal.size()]);
    }

    protected static class FilteredSynchronizeModelOperation
    extends SynchronizeModelOperation {
        protected IActionOperation executable;

        public FilteredSynchronizeModelOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IActionOperation executable) {
            super(configuration, elements);
            this.executable = executable;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.executable != null) {
                ProgressMonitorUtility.doTaskExternal((IActionOperation)this.executable, (IProgressMonitor)monitor);
            }
        }

        protected boolean canRunAsJob() {
            return true;
        }

        protected String getJobName() {
            return this.executable == null ? super.getJobName() : this.executable.getOperationName();
        }
    }
}

