/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.eclipse.team.svn.ui.synchronize.variant.ResourceVariant;
import org.eclipse.team.svn.ui.utility.DateFormatter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class SVNChangeSetCollector
extends SyncInfoSetChangeSetCollector {
    public SVNChangeSetCollector(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    public void dispose() {
        SVNChangeSetCapability.isEnabled = false;
        super.dispose();
    }

    protected void add(SyncInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return;
        }
        HashMap<Long, SVNCheckedInChangeSet> sets = new HashMap<Long, SVNCheckedInChangeSet>();
        final HashSet<SVNCheckedInChangeSet> added = new HashSet<SVNCheckedInChangeSet>();
        ChangeSet[] changeSetArray = this.getSets();
        int n = changeSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            SVNCheckedInChangeSet svnSet = (SVNCheckedInChangeSet)set;
            sets.put(svnSet.getRevision(), svnSet);
            ++n2;
        }
        String svnAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.Author");
        String svnDate = SVNTeamPlugin.instance().getResource("SVNInfo.Date");
        String svnNoAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor");
        String svnNoDate = SVNTeamPlugin.instance().getResource("SVNInfo.NoDate");
        SyncInfo[] syncInfoArray = infos;
        int n3 = infos.length;
        int n4 = 0;
        while (n4 < n3) {
            SyncInfo info = syncInfoArray[n4];
            if ((info.getKind() & 8) != 0) {
                ResourceVariant remote = (ResourceVariant)info.getRemote();
                ILocalResource resource = remote.getResource();
                long revision = resource.getRevision();
                SVNCheckedInChangeSet set = (SVNCheckedInChangeSet)((Object)sets.get(revision));
                boolean updateName = false;
                if (set == null) {
                    set = new SVNCheckedInChangeSet();
                    set.author = resource.getAuthor();
                    set.date = new Date(resource.getLastCommitDate());
                    set.revision = revision;
                    if (resource instanceof IResourceChange) {
                        set.comment = ((IResourceChange)resource).getComment();
                    }
                    updateName = true;
                    sets.put(revision, set);
                    added.add(set);
                } else if (set.date.getTime() == 0L) {
                    updateName = true;
                    set.date = new Date(resource.getLastCommitDate());
                } else if (set.author == null) {
                    updateName = true;
                    set.author = resource.getAuthor();
                }
                if (updateName) {
                    String name = String.valueOf(String.valueOf(revision)) + " " + (resource.getLastCommitDate() == 0L ? svnNoDate : MessageFormat.format(svnDate, DateFormatter.formatDate(set.date))) + " " + (resource.getAuthor() == null ? svnNoAuthor : MessageFormat.format(svnAuthor, resource.getAuthor()));
                    if (set.comment != null) {
                        String comment = set.comment;
                        if (FileUtility.isWindows()) {
                            comment = comment.replaceAll("\r\n|\r|\n", " ");
                        }
                        name = String.valueOf(name) + " " + comment;
                    }
                    set.setName(name);
                }
                set.add(info);
            }
            ++n4;
        }
        this.performUpdate(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (SVNCheckedInChangeSet set : added) {
                    SVNChangeSetCollector.this.add((ChangeSet)set);
                }
            }
        }, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initializeSets() {
    }

    public static class SVNCheckedInChangeSet
    extends CheckedInChangeSet {
        private String author;
        private String comment;
        private Date date;
        private long revision;

        public long getRevision() {
            return this.revision;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getComment() {
            return this.comment;
        }

        public void setName(String name) {
            super.setName(name);
        }
    }
}

