/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.events.IRepositoriesStateChangedListener;
import org.eclipse.team.svn.core.svnstorage.events.RepositoriesStateChangedEvent;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.action.AbstractSVNTeamAction;
import org.eclipse.team.svn.ui.action.remote.DeleteAction;
import org.eclipse.team.svn.ui.action.remote.OpenFileAction;
import org.eclipse.team.svn.ui.action.remote.OpenFileWithAction;
import org.eclipse.team.svn.ui.action.remote.RefreshAction;
import org.eclipse.team.svn.ui.action.remote.management.DiscardRepositoryLocationAction;
import org.eclipse.team.svn.ui.action.remote.management.DiscardRevisionLinksAction;
import org.eclipse.team.svn.ui.action.remote.management.NewRepositoryLocationAction;
import org.eclipse.team.svn.ui.action.remote.management.RefreshRepositoryLocationAction;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.browser.RepositoryBrowser;
import org.eclipse.team.svn.ui.repository.model.RepositoriesRoot;
import org.eclipse.team.svn.ui.repository.model.RepositoryContentProvider;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class RepositoriesView
extends ViewPart {
    public static final String VIEW_ID = RepositoriesView.class.getName();
    protected RepositoryTreeViewer repositoryTree;
    protected RepositoriesRoot root;
    protected DrillDownAdapter ddAdapter;
    protected Action showBrowserAction;
    protected IPartListener2 partListener;

    public static MenuManager newMenuInstance(final ISelectionProvider provider) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object item;
                MenuManager sub = new MenuManager(SVNTeamUIPlugin.instance().getResource("RepositoriesView.New"), "addMenu");
                sub.add((IContributionItem)new Separator("mainGroup"));
                sub.add((IContributionItem)new Separator("managementGroup"));
                sub.add((IContributionItem)new Separator("repositoryGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                Action newRepositoryLocation = new Action(SVNTeamUIPlugin.instance().getResource("RepositoriesView.RepositoryLocation")){

                    public void run() {
                        new NewRepositoryLocationAction().run((IAction)this);
                    }
                };
                newRepositoryLocation.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/objects/repository.gif"));
                sub.add((IAction)newRepositoryLocation);
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("checkoutGroup"));
                sub = new MenuManager(SVNTeamUIPlugin.instance().getResource("RepositoriesView.OpenWith"), "openWithMenu");
                sub.add((IContributionItem)new Separator("dynamicGroup"));
                IStructuredSelection selection = (IStructuredSelection)provider.getSelection();
                if (selection.size() == 1 && (item = selection.getFirstElement()) instanceof RepositoryFile) {
                    String name = ((RepositoryFile)item).getRepositoryResource().getName();
                    IEditorDescriptor[] editors = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getEditors(name);
                    int i = 0;
                    while (i < editors.length) {
                        if (!editors[i].getId().equals("org.eclipse.ui.DefaultTextEditor")) {
                            final OpenFileWithAction openAction = new OpenFileWithAction(editors[i].getId(), false);
                            Action wrapper = new Action(editors[i].getLabel()){

                                public void run() {
                                    openAction.run((IAction)this);
                                }
                            };
                            openAction.selectionChanged((IAction)wrapper, (ISelection)selection);
                            sub.add((IAction)wrapper);
                        }
                        ++i;
                    }
                }
                sub.add((IContributionItem)new Separator("fixedGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("miscGroup"));
                sub = new MenuManager(SVNTeamUIPlugin.instance().getResource("RepositoriesView.Refactor"), "refactorMenu");
                sub.add((IContributionItem)new Separator("mainGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("locationGroup"));
                manager.add((IContributionItem)new Separator("propertiesGroup"));
                manager.add((IContributionItem)new Separator("importExportGroup"));
                sub = new MenuManager(SVNTeamUIPlugin.instance().getResource("RepositoriesView.CompareWith"), "compareMenu");
                sub.add((IContributionItem)new Separator("mainGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                manager.prependToGroup("importExportGroup", (IContributionItem)sub);
                manager.add((IContributionItem)new Separator("refreshGroup"));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        return menuMgr;
    }

    public void createPartControl(Composite parent) {
        this.repositoryTree = new RepositoryTreeViewer(parent, 770);
        this.repositoryTree.setContentProvider((IContentProvider)new RepositoryContentProvider(this.repositoryTree));
        this.repositoryTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.repositoryTree);
        this.root = new RepositoriesRoot();
        this.repositoryTree.setInput(this.root);
        this.ddAdapter = new DrillDownAdapter((TreeViewer)this.repositoryTree);
        Tree tree = this.repositoryTree.getTree();
        MenuManager menuMgr = RepositoriesView.newMenuInstance((ISelectionProvider)this.repositoryTree);
        tree.setMenu(menuMgr.createContextMenu((Control)tree));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.repositoryTree);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this.ddAdapter.addNavigationActions(tbm);
        Action tAction = null;
        tAction = new Action(SVNTeamUIPlugin.instance().getResource("SVNView.Refresh.Label")){

            public void run() {
                if (RepositoriesView.this.repositoryTree.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.repositoryTree.getSelection();
                    RepositoriesView.this.handleRefresh(selection);
                }
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        tAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("SVNView.Refresh.ToolTip"));
        tbm.add((IContributionItem)new Separator("collapseAllGroup"));
        tAction = new Action(SVNTeamUIPlugin.instance().getResource("RepositoriesView.CollapseAll.Label")){

            public void run() {
                RepositoriesView.this.repositoryTree.collapseAll();
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/collapseall.gif"));
        tAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("RepositoriesView.CollapseAll.ToolTip"));
        tbm.add((IContributionItem)new Separator("repositoryGroup"));
        tAction = new Action(SVNTeamUIPlugin.instance().getResource("RepositoriesView.NewLocation.Label")){

            public void run() {
                new NewRepositoryLocationAction().run((IAction)this);
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/repositories/new_location.gif"));
        tAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("RepositoriesView.NewLocation.ToolTip"));
        this.showBrowserAction = new Action(SVNTeamUIPlugin.instance().getResource("RepositoriesView.ShowBrowser.Label"), 2){

            public void run() {
                if (this.isChecked()) {
                    RepositoriesView.this.showRepositoryBrowser(true);
                } else {
                    RepositoriesView.this.hideRepositoryBrowser();
                }
            }
        };
        tbm.add((IAction)this.showBrowserAction);
        this.showBrowserAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/repositories/browser.gif"));
        this.showBrowserAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("RepositoriesView.ShowBrowser.ToolTip"));
        this.repositoryTree.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (RepositoriesView.this.repositoryTree.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.repositoryTree.getSelection();
                    if (event.keyCode == 0x100000E) {
                        RepositoriesView.this.handleRefresh(selection);
                    } else if (event.keyCode == 127) {
                        RepositoriesView.this.handleDeleteKey(selection);
                    }
                }
            }
        });
        this.repositoryTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    RepositoriesView.this.handleDoubleClick(structured);
                }
            }
        });
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(VIEW_ID)) {
                    RepositoriesView.this.refreshRepositoriesImpl(false);
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(RepositoryBrowser.VIEW_ID)) {
                    RepositoriesView.this.getViewSite().getPage().removePartListener((IPartListener2)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.partListener);
        SVNRemoteStorage.instance().addRepositoriesStateChangedListener(new IRepositoriesStateChangedListener(){

            public void repositoriesStateChanged(RepositoriesStateChangedEvent event) {
                if (event.getAction() == 0) {
                    RepositoriesView.refreshRepositories(false);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.repositoryViewContext");
    }

    public void dispose() {
        super.dispose();
        this.getViewSite().getPage().removePartListener(this.partListener);
    }

    public void setFocus() {
        this.repositoryTree.getControl().setFocus();
    }

    public static void refresh(Object where) {
        RepositoriesView.refresh(where, null);
    }

    public static void refresh(Object where, RepositoryTreeViewer.IRefreshVisitor visitor) {
        RepositoriesView instance = RepositoriesView.instance();
        if (instance != null) {
            instance.repositoryTree.refresh(where, visitor, false);
        }
    }

    public static void refreshRepositories(boolean deep) {
        RepositoriesView instance = RepositoriesView.instance();
        if (instance != null) {
            instance.refreshRepositoriesImpl(deep);
        }
    }

    public RepositoryTreeViewer getRepositoryTree() {
        return this.repositoryTree;
    }

    public void refreshButtonsState() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean isBrowserVisible = SVNTeamPreferences.getRepositoryBoolean(store, "repositoryBrowser");
        this.showBrowserAction.setChecked(isBrowserVisible);
    }

    public static RepositoriesView instance() {
        final RepositoriesView[] view = new RepositoriesView[1];
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = SVNTeamUIPlugin.instance().getWorkbench().getActiveWorkbenchWindow();
                if (window != null && window.getActivePage() != null) {
                    view[0] = (RepositoriesView)window.getActivePage().findView(VIEW_ID);
                }
            }
        });
        return view[0];
    }

    protected void refreshRepositoriesImpl(boolean deep) {
        if (deep) {
            this.root.refresh();
        } else {
            this.root.softRefresh();
        }
        this.repositoryTree.refresh();
    }

    protected void showRepositoryBrowser(boolean force) {
        final IWorkbenchPage page = this.getSite().getPage();
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new AbstractActionOperation("Operation.ShowBrowser"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                RepositoryBrowser browser = (RepositoryBrowser)page.showView(RepositoryBrowser.VIEW_ID);
                ISelection selection = RepositoriesView.this.repositoryTree.getSelection();
                browser.selectionChanged(new SelectionChangedEvent((ISelectionProvider)RepositoriesView.this.repositoryTree, selection));
            }
        });
    }

    protected void hideRepositoryBrowser() {
        IWorkbenchPage page = this.getSite().getPage();
        IViewPart part = page.findView(RepositoryBrowser.VIEW_ID);
        if (part != null) {
            page.hideView(part);
        }
    }

    protected void handleRefresh(IStructuredSelection selection) {
        Action tmp = new Action(){};
        AbstractRepositoryTeamAction action = null;
        action = new RefreshAction();
        action.selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        }
        action = new RefreshRepositoryLocationAction();
        action.selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        }
    }

    protected void handleDeleteKey(IStructuredSelection selection) {
        Action tmp = new Action(){};
        AbstractRepositoryTeamAction action = new DeleteAction();
        action.selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        } else {
            action = new DiscardRevisionLinksAction();
            action.selectionChanged((IAction)tmp, (ISelection)selection);
            action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
            if (tmp.isEnabled()) {
                action.run((IAction)tmp);
            } else {
                action = new DiscardRepositoryLocationAction();
                action.selectionChanged((IAction)tmp, (ISelection)selection);
                action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
                if (tmp.isEnabled()) {
                    action.run((IAction)tmp);
                }
            }
        }
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        Action tmp = new Action(){};
        OpenFileAction action = new OpenFileAction();
        ((AbstractSVNTeamAction)action).selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        }
    }

    public boolean canGoBack() {
        return this.ddAdapter.canGoBack();
    }

    public void goBack() {
        this.ddAdapter.goBack();
    }
}

