/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SVNTeamPerformancePage
extends AbstractSVNTeamPreferencesPage {
    protected Button computeDeepButton;
    protected Button preciseEnablementsButton;
    protected Button enableCacheButton;
    protected boolean computeDeep;
    protected boolean preciseEnablements;
    protected boolean enableCache;

    public void init(IWorkbench workbench) {
        this.setDescription(SVNTeamUIPlugin.instance().getResource("PerformancePreferencePage.optionsDesc"));
    }

    protected void saveValues(IPreferenceStore store) {
        SVNTeamPreferences.setDecorationBoolean(store, "compute.deep", this.computeDeep);
        SVNTeamPreferences.setDecorationBoolean(store, "precise.enablements", this.preciseEnablements);
        SVNTeamPreferences.setDecorationBoolean(store, "enable.cache", this.computeDeep | this.enableCache);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.computeDeep = true;
        this.preciseEnablements = false;
        this.enableCache = true;
    }

    protected void loadValues(IPreferenceStore store) {
        this.computeDeep = SVNTeamPreferences.getDecorationBoolean(store, "compute.deep");
        this.preciseEnablements = SVNTeamPreferences.getDecorationBoolean(store, "precise.enablements");
        this.enableCache = SVNTeamPreferences.getDecorationBoolean(store, "enable.cache");
    }

    protected void initializeControls() {
        this.computeDeepButton.setSelection(this.computeDeep);
        this.preciseEnablementsButton.setSelection(this.preciseEnablements);
        this.enableCacheButton.setSelection(this.enableCache);
        if (this.computeDeep || this.preciseEnablements) {
            this.enableCacheButton.setEnabled(false);
        } else if (!this.enableCache) {
            this.computeDeepButton.setEnabled(false);
            this.preciseEnablementsButton.setEnabled(false);
        }
    }

    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        Composite noteComposite = new Composite(composite, 4);
        layout = new GridLayout();
        layout.marginWidth = 0;
        noteComposite.setLayout((Layout)layout);
        noteComposite.setLayoutData((Object)new GridData(768));
        Label separator = new Label(noteComposite, 258);
        data = new GridData(768);
        separator.setLayoutData((Object)data);
        this.computeDeepButton = new Button(composite, 32);
        this.computeDeepButton.setLayoutData((Object)new GridData());
        this.computeDeepButton.setText(SVNTeamUIPlugin.instance().getResource("PerformancePreferencePage.computeDeep"));
        this.computeDeepButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamPerformancePage.this.computeDeep = SVNTeamPerformancePage.this.computeDeepButton.getSelection();
                SVNTeamPerformancePage.this.enableCacheButton.setEnabled(!(SVNTeamPerformancePage.this.computeDeep | SVNTeamPerformancePage.this.preciseEnablements));
            }
        });
        this.preciseEnablementsButton = new Button(composite, 32);
        this.preciseEnablementsButton.setLayoutData((Object)new GridData());
        this.preciseEnablementsButton.setText(SVNTeamUIPlugin.instance().getResource("PerformancePreferencePage.preciseEnablements"));
        this.preciseEnablementsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamPerformancePage.this.preciseEnablements = SVNTeamPerformancePage.this.preciseEnablementsButton.getSelection();
                SVNTeamPerformancePage.this.enableCacheButton.setEnabled(!(SVNTeamPerformancePage.this.computeDeep | SVNTeamPerformancePage.this.preciseEnablements));
            }
        });
        this.enableCacheButton = new Button(composite, 32);
        this.enableCacheButton.setLayoutData((Object)new GridData());
        this.enableCacheButton.setText(SVNTeamUIPlugin.instance().getResource("PerformancePreferencePage.enableCache"));
        this.enableCacheButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamPerformancePage.this.enableCache = SVNTeamPerformancePage.this.enableCacheButton.getSelection();
                SVNTeamPerformancePage.this.computeDeepButton.setEnabled(SVNTeamPerformancePage.this.enableCache);
                SVNTeamPerformancePage.this.preciseEnablementsButton.setEnabled(SVNTeamPerformancePage.this.enableCache);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.performancePreferencesContext");
        return composite;
    }
}

