/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.composite.ResourceSelectionComposite;
import org.eclipse.team.svn.ui.event.IResourceSelectionChangeListener;
import org.eclipse.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;

public abstract class AbstractResourceSelectionPanel
extends AbstractDialogPanel {
    protected IResource[] resources;
    protected CheckboxTableViewer tableViewer;
    protected ResourceSelectionComposite selectionComposite;
    protected IResource[] userSelectedResources;

    public AbstractResourceSelectionPanel(IResource[] resources, IResource[] userSelectedResources, String[] buttonNames) {
        super(buttonNames);
        this.resources = resources;
        this.userSelectedResources = userSelectedResources;
    }

    public IResource[] getSelectedResources() {
        return this.selectionComposite != null ? this.selectionComposite.getSelectedResources() : null;
    }

    public IResource[] getNotSelectedResources() {
        return this.selectionComposite != null ? this.selectionComposite.getNotSelectedResources() : null;
    }

    public Point getPrefferedSizeImpl() {
        return new Point(600, -1);
    }

    public void createControlsImpl(Composite parent) {
        this.selectionComposite = new ResourceSelectionComposite(parent, 0, this.resources, false, this.userSelectedResources);
        GridData data = new GridData(1808);
        data.heightHint = 210;
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.addResourcesSelectionChangedListener(new IResourceSelectionChangeListener(){

            public void resourcesSelectionChanged(ResourceSelectionChangedEvent event) {
                AbstractResourceSelectionPanel.this.validateContent();
            }
        });
        this.attachTo((Control)this.selectionComposite, new AbstractVerifier(){

            protected String getErrorMessage(Control input) {
                IResource[] selection = AbstractResourceSelectionPanel.this.getSelectedResources();
                if (selection == null || selection.length == 0) {
                    return SVNTeamUIPlugin.instance().getResource("ResourceSelectionComposite.Verifier.Error");
                }
                return null;
            }

            protected String getWarningMessage(Control input) {
                return null;
            }
        });
        this.addContextMenu();
    }

    protected void saveChangesImpl() {
    }

    protected void cancelChangesImpl() {
    }

    protected void addContextMenu() {
    }
}

